/*
 * Decompiled with CFR 0.152.
 */
package io.jans.jsf2.customization;

import com.sun.faces.util.FacesLogger;
import io.jans.jsf2.customization.Utils;
import io.jans.util.StringHelper;
import jakarta.faces.application.ApplicationConfigurationPopulator;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class FacesLocalizationConfigPopulator
extends ApplicationConfigurationPopulator {
    private static final String DEFAULT_LANGUAGE_PATH = "/classes/";
    private Logger log = LoggerFactory.getLogger(FacesLocalizationConfigPopulator.class);

    public void populateApplicationConfiguration(Document toPopulate) {
        this.populateLocalizations(toPopulate);
    }

    private void populateLocalizations(Document toPopulate) {
        this.log.debug("Starting localization configuration populator");
        if (Utils.isCustomLocalizationDirExists()) {
            String customLocalizationPath = Utils.getCustomLocalizationPath();
            this.log.debug("Adding localizations from custom dir folder: {}", (Object)customLocalizationPath);
            try {
                this.findAndAddLocalizations(toPopulate, customLocalizationPath);
            }
            catch (Exception ex) {
                FacesLogger.CONFIG.getLogger().log(Level.SEVERE, "Can't add localizations from custom dir");
            }
        }
        try {
            URL[] ulrs;
            this.log.debug("Adding localizations from application resurces");
            for (URL url : ulrs = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs()) {
                int count;
                if (!url.getFile().endsWith(DEFAULT_LANGUAGE_PATH) || (count = this.findAndAddLocalizations(toPopulate, url.getFile())) <= 0) continue;
                this.log.debug("Added {} application localizations from war folder: {}", (Object)count, (Object)url.getFile());
            }
        }
        catch (Exception ex) {
            this.log.error("Failed to populate application localizations", (Throwable)ex);
        }
    }

    private int findAndAddLocalizations(Document toPopulate, String path) throws Exception {
        Collection languageFiles;
        String languageFilePattern = this.getLanguageFilePattern();
        RegexFileFilter regexFileFilter = new RegexFileFilter(languageFilePattern);
        Pattern regexFilePatern = Pattern.compile(languageFilePattern);
        File file = new File(path);
        try {
            languageFiles = FileUtils.listFiles((File)file, (IOFileFilter)regexFileFilter, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        }
        catch (RuntimeException e) {
            this.log.trace("Failed to find custom localizations");
            return 0;
        }
        if (languageFiles.size() == 0) {
            return 0;
        }
        this.log.debug("Found '{}' language files", (Object)languageFiles.size());
        ArrayList<String> localeNames = new ArrayList<String>();
        for (File languageFile : languageFiles) {
            Matcher matcher = regexFilePatern.matcher(languageFile.getName());
            if (!matcher.matches()) continue;
            String localeName = matcher.group(1);
            localeNames.add(localeName);
        }
        this.log.info("Adding languages '{}' from dir folder: {}", localeNames, (Object)path);
        this.updateDocument(toPopulate, localeNames);
        return localeNames.size();
    }

    private void updateDocument(Document toPopulate, List<String> localeNames) {
        String ns = toPopulate.getDocumentElement().getNamespaceURI();
        Element rootElement = toPopulate.getDocumentElement();
        Node applicationNode = this.getChildOrCreate(toPopulate, ns, rootElement, "application");
        Node localeConfigNode = this.getChildOrCreate(toPopulate, ns, applicationNode, "locale-config");
        for (String localeName : localeNames) {
            Element supportedLocaleElement = toPopulate.createElementNS(ns, "supported-locale");
            Node supportedLocaleNode = localeConfigNode.appendChild(supportedLocaleElement);
            supportedLocaleNode.appendChild(toPopulate.createTextNode(localeName));
        }
    }

    protected Node getChildOrCreate(Document toPopulate, String ns, Node rootElement, String childNodeName) {
        if (rootElement.hasChildNodes()) {
            NodeList nodeList = rootElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!StringHelper.equals((String)nodeList.item(i).getNodeName(), (String)childNodeName)) continue;
                return nodeList.item(i);
            }
        }
        Element applicationElement = toPopulate.createElementNS(ns, childNodeName);
        Node applicationNode = rootElement.appendChild(applicationElement);
        return applicationNode;
    }

    public abstract String getLanguageFilePattern();
}

