/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.el;

import io.jans.service.el.ConstantResolver;
import io.jans.service.el.ExtendedELContext;
import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Map;

@Dependent
public class ExpressionEvaluator
implements Serializable {
    private static final long serialVersionUID = -16629423172996440L;
    @Inject
    private ExtendedELContext ctx;
    @Inject
    private ExpressionFactory expressionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T evaluateValueExpression(String expression, Class<T> expectedType, Map<String, Object> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return this.evaluateValueExpression(expression, expectedType);
        }
        ConstantResolver constantResolver = this.ctx.getConstantResolver();
        try {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                constantResolver.addConstant(parameter.getKey(), parameter.getValue());
            }
            Object object = this.expressionFactory.createValueExpression((ELContext)this.ctx, expression, expectedType).getValue((ELContext)this.ctx);
            return (T)object;
        }
        finally {
            for (String parameterName : parameters.keySet()) {
                constantResolver.removeConstant(parameterName);
            }
        }
    }

    public <T> T evaluateValueExpression(String expression, Class<T> expectedType) {
        return (T)this.expressionFactory.createValueExpression((ELContext)this.ctx, expression, expectedType).getValue((ELContext)this.ctx);
    }

    public Object evaluateValueExpression(String expression) {
        return this.evaluateValueExpression(expression, Object.class);
    }

    public <T> T invokeMethodExpression(String expression, Class<T> expectedReturnType, Object[] args, Class<?>[] argTypes) {
        return (T)this.expressionFactory.createMethodExpression((ELContext)this.ctx, expression, expectedReturnType, (Class[])argTypes).invoke((ELContext)this.ctx, args);
    }

    public <T> T invokeMethodExpression(String expression, Class<T> expectedReturnType) {
        return this.invokeMethodExpression(expression, expectedReturnType, new Object[0], new Class[0]);
    }

    public Object invokeMethodExpression(String expression) {
        return this.invokeMethodExpression(expression, Object.class, new Object[0], new Class[0]);
    }

    public Object invokeMethodExpression(String expression, Object ... args) {
        return this.invokeMethodExpression(expression, Object.class, args, new Class[args.length]);
    }

    public <T> T resolveName(String name, Class<T> expectedType) {
        return this.evaluateValueExpression(this.toExpression(name), expectedType);
    }

    public Object resolveName(String name) {
        return this.resolveName(name, Object.class);
    }

    private String toExpression(String name) {
        return "#{" + name + "}";
    }
}

