/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.message.provider;

import io.jans.service.cache.AbstractRedisProvider;
import io.jans.service.cache.RedisConfiguration;
import io.jans.service.cache.RedisProvider;
import io.jans.service.cache.RedisProviderFactory;
import io.jans.service.message.model.config.MessageConfiguration;
import io.jans.service.message.model.config.MessageProviderType;
import io.jans.service.message.model.config.RedisMessageConfiguration;
import io.jans.service.message.provider.AbstractMessageProvider;
import io.jans.service.message.pubsub.PubSubInterface;
import io.jans.service.message.pubsub.PubSubRedisAdapter;
import io.jans.util.security.StringEncrypter;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.ShardedJedisPool;

@ApplicationScoped
public class RedisMessageProvider
extends AbstractMessageProvider<AbstractRedisProvider> {
    @Inject
    private Logger log;
    @Inject
    private MessageConfiguration messageConfiguration;
    @Inject
    private StringEncrypter stringEncrypter;
    private ConcurrentHashMap<Integer, PubSubRedisAdapter> subscibedPubSubs;
    private AbstractRedisProvider redisProvider;
    private ExecutorService executorService;

    @PostConstruct
    public void init() {
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.log.debug("Destroying RedisProvider");
        this.shutdown();
        if (this.redisProvider != null) {
            this.redisProvider.destroy();
        }
        this.log.debug("Destroyed RedisMessageProvider");
    }

    @Override
    public void create(ExecutorService executorService) {
        this.executorService = executorService;
        this.subscibedPubSubs = new ConcurrentHashMap();
        try {
            RedisMessageConfiguration redisConfiguration = this.messageConfiguration.getRedisConfiguration();
            this.decryptPassword(redisConfiguration);
            this.log.debug("Starting RedisMessageProvider messages ... configuration {}", (Object)redisConfiguration);
            this.redisProvider = RedisProviderFactory.create((RedisConfiguration)redisConfiguration);
            this.redisProvider.create();
            this.log.debug("RedisMessageProvider message started.");
        }
        catch (Exception ex) {
            this.log.error("Failed to start RedisMessageProvider messages", (Throwable)ex);
            throw new IllegalStateException("Error starting RedisMessageProvider messages", ex);
        }
    }

    public void configure(MessageConfiguration messageConfiguration, StringEncrypter stringEncrypter) {
        this.log = LoggerFactory.getLogger(RedisProvider.class);
        this.messageConfiguration = messageConfiguration;
        this.stringEncrypter = stringEncrypter;
    }

    private void decryptPassword(RedisMessageConfiguration redisConfiguration) {
        try {
            String encryptedPassword = redisConfiguration.getPassword();
            if (StringUtils.isNotBlank((CharSequence)encryptedPassword)) {
                redisConfiguration.setPassword(this.stringEncrypter.decrypt(encryptedPassword));
                this.log.trace("Decrypted redis password successfully.");
            }
        }
        catch (StringEncrypter.EncryptionException e) {
            this.log.error("Error during redis password decryption", (Throwable)e);
        }
    }

    public boolean isConnected() {
        return this.redisProvider.isConnected();
    }

    @Override
    public AbstractRedisProvider getDelegate() {
        return this.redisProvider;
    }

    @Override
    public MessageProviderType getProviderType() {
        return MessageProviderType.REDIS;
    }

    @Override
    public void subscribe(PubSubInterface pubSub, String ... channels) {
        this.log.info("Starting new thread for subscribing to Redis channels {}", Arrays.asList(channels));
        Object objectPool = this.redisProvider.getDelegate();
        if (objectPool instanceof JedisPool) {
            this.executorService.execute(() -> {
                Jedis jedis = ((JedisPool)objectPool).getResource();
                PubSubRedisAdapter pubSubRedisAdapter = new PubSubRedisAdapter(pubSub);
                this.subscibedPubSubs.put(System.identityHashCode(pubSub), pubSubRedisAdapter);
                jedis.subscribe((JedisPubSub)pubSubRedisAdapter, channels);
            });
        } else if (objectPool instanceof JedisCluster) {
            this.executorService.execute(() -> {
                JedisCluster jedis = (JedisCluster)objectPool;
                PubSubRedisAdapter pubSubRedisAdapter = new PubSubRedisAdapter(pubSub);
                this.subscibedPubSubs.put(System.identityHashCode(pubSub), pubSubRedisAdapter);
                jedis.subscribe((JedisPubSub)pubSubRedisAdapter, channels);
            });
        } else if (objectPool instanceof ShardedJedisPool) {
            throw new UnsupportedOperationException("Sharded pool not provides PubSub in 3.9.x API");
        }
        this.log.info("Stopping thread after subscription end to Redis from channels {}", Arrays.asList(channels));
    }

    @Override
    public void unsubscribe(PubSubInterface pubSub) {
        this.log.info("Starting end subscription to Redis for {}", (Object)pubSub);
        int pubSubIdentifier = System.identityHashCode(pubSub);
        PubSubRedisAdapter pubSubRedisAdapter = this.subscibedPubSubs.get(pubSubIdentifier);
        if (pubSubRedisAdapter == null) {
            this.log.warn("PubSub {} in unsubscribe request is not registered", (Object)pubSub);
            return;
        }
        pubSubRedisAdapter.unsubscribe();
        this.subscibedPubSubs.remove(pubSubIdentifier);
        this.log.info("Sent request to end subscription to Redis for {}", (Object)pubSub);
    }

    @Override
    public boolean publish(String channel, String message) {
        Object objectPool = this.redisProvider.getDelegate();
        if (objectPool instanceof JedisPool) {
            CompletableFuture.runAsync(() -> {
                JedisPool pool = (JedisPool)objectPool;
                Jedis jedis = pool.getResource();
                try {
                    jedis.publish(channel, message);
                }
                finally {
                    pool.returnResource(jedis);
                }
            });
        } else if (objectPool instanceof JedisCluster) {
            CompletableFuture.runAsync(() -> {
                Jedis jedis = ((JedisPool)objectPool).getResource();
                jedis.publish(channel, message);
            });
        } else if (objectPool instanceof ShardedJedisPool) {
            throw new UnsupportedOperationException("Sharded pool not provides PubSub in 3.9.x API");
        }
        return true;
    }

    @Override
    public void shutdown() {
        for (PubSubRedisAdapter pubSubRedisAdapter : this.subscibedPubSubs.values()) {
            try {
                pubSubRedisAdapter.unsubscribe();
            }
            catch (Throwable ex) {
                this.log.error("Failed to unsubscribe for {}", (Object)pubSubRedisAdapter.getPubSub());
            }
        }
        this.subscibedPubSubs.clear();
    }
}

