/*
 * Decompiled with CFR 0.152.
 */
package io.jans.model.user;

import io.jans.orm.annotation.AttributeEnum;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum UserRole implements AttributeEnum
{
    ADMIN("admin"),
    OWNER("owner"),
    MANAGER("manager"),
    USER("user"),
    WHITEPAGES("whitePages");

    private String value;
    private static Map<String, UserRole> MAP_BY_VALUES;

    private UserRole(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getRoleName() {
        return this.value;
    }

    public String getDisplayName() {
        return this.value;
    }

    public static UserRole getByValue(String value) {
        return MAP_BY_VALUES.get(value);
    }

    public static UserRole[] getByValues(String[] values) {
        UserRole[] roles = new UserRole[values.length];
        for (int i = 0; i < values.length; ++i) {
            roles[i] = UserRole.getByValue(values[i]);
        }
        return roles;
    }

    public static boolean equals(UserRole[] roles1, UserRole[] roles2) {
        Arrays.sort((Object[])roles1);
        Arrays.sort((Object[])roles2);
        return Arrays.equals((Object[])roles1, (Object[])roles2);
    }

    public static boolean containsRole(UserRole[] roles, UserRole role) {
        if (roles == null || role == null) {
            return false;
        }
        for (int i = 0; i < roles.length; ++i) {
            if (!role.equals((Object)roles[i])) continue;
            return true;
        }
        return false;
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return UserRole.getByValue(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        MAP_BY_VALUES = new HashMap<String, UserRole>();
        for (UserRole enumType : UserRole.values()) {
            MAP_BY_VALUES.put(enumType.getValue(), enumType);
        }
    }
}

