/*
 * Decompiled with CFR 0.152.
 */
package io.jans.model;

import io.jans.orm.annotation.AttributeEnum;
import java.util.HashMap;
import java.util.Map;

public enum ApplicationType implements AttributeEnum
{
    OX_AUTH("jans_auth", "Jans Auth"),
    OX_TRUST("oxtrust", "oxTrust"),
    FIDO2("fido2", "FIDO2"),
    SCIM("scim", "SCIM"),
    CACHE_REFRESH("link_interception", "Link Interception"),
    JANS_CONFIG_API("jans_config_api", "Jans Config API"),
    JANS_CLIENT_API("jans_client_api", "Jans Client API"),
    JANS_LOCK("jans_lock", "Jans Lock");

    private String value;
    private String displayName;
    private static Map<String, ApplicationType> MAP_BY_VALUES;

    private ApplicationType(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static ApplicationType getByValue(String value) {
        return MAP_BY_VALUES.get(value);
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return ApplicationType.getByValue(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        MAP_BY_VALUES = new HashMap<String, ApplicationType>();
        for (ApplicationType enumType : ApplicationType.values()) {
            MAP_BY_VALUES.put(enumType.getValue(), enumType);
        }
    }
}

