/*
 * Decompiled with CFR 0.152.
 */
package io.jans.saml.metadata.model;

import io.jans.saml.metadata.model.ContactPerson;
import io.jans.saml.metadata.model.KeyDescriptor;
import io.jans.saml.metadata.model.Organization;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class RoleDescriptor {
    private String id = null;
    private Date validUntil = null;
    private Duration cacheDuration = null;
    private List<String> supportedProtocols = new ArrayList<String>();
    private String errorUrl = null;
    private List<KeyDescriptor> keyDescriptors = new ArrayList<KeyDescriptor>();
    private Organization organization = null;
    private List<ContactPerson> contacts = new ArrayList<ContactPerson>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(Date validUntil) {
        this.validUntil = validUntil;
    }

    public Duration getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(Duration cacheDuration) {
        this.cacheDuration = cacheDuration;
    }

    public String getErrorUrl() {
        return this.errorUrl;
    }

    public void setErrorUrl(String errorUrl) {
        this.errorUrl = errorUrl;
    }

    public List<String> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    public void addSupportedProtocol(String protocol) {
        this.supportedProtocols.add(protocol);
    }

    public void setSupportedProtocols(List<String> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    public List<KeyDescriptor> getKeyDescriptors() {
        return this.keyDescriptors;
    }

    public List<KeyDescriptor> getEncryptionKeys() {
        return this.keyDescriptors.stream().filter(k -> k.isEncryptionKey()).collect(Collectors.toList());
    }

    public List<KeyDescriptor> getSigningKeys() {
        return this.keyDescriptors.stream().filter(k -> k.isSigningKey()).collect(Collectors.toList());
    }

    public void addKeyDescriptor(KeyDescriptor keyDescriptor) {
        this.keyDescriptors.add(keyDescriptor);
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public List<ContactPerson> getContacts() {
        return this.contacts;
    }

    public void addContact(ContactPerson contact) {
        this.contacts.add(contact);
    }
}

