/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.custom.script;

import io.jans.orm.PersistenceEntryManager;
import io.jans.service.PythonService;
import io.jans.service.custom.script.CustomScriptManager;
import io.jans.service.custom.script.ExternalScriptService;
import io.jans.service.custom.script.ExternalTypeCreator;
import io.jans.service.custom.script.StandaloneCustomScriptService;
import jakarta.enterprise.inject.Vetoed;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

@Vetoed
public class StandaloneCustomScriptManager
extends CustomScriptManager {
    private static final long serialVersionUID = -7212146007659551839L;
    private final List<ExternalScriptService> externalScriptServices = new ArrayList<ExternalScriptService>();

    public StandaloneCustomScriptManager(PersistenceEntryManager entryManager, String scriptsBaseDn) {
        this(entryManager, scriptsBaseDn, null);
    }

    public StandaloneCustomScriptManager(PersistenceEntryManager entryManager, String scriptsBaseDn, String pythonModulesDir) {
        StandaloneCustomScriptService standaloneCustomScriptService = new StandaloneCustomScriptService();
        standaloneCustomScriptService.configure(entryManager, scriptsBaseDn);
        ExternalTypeCreator externalTypeCreator = new ExternalTypeCreator();
        if (StringUtils.isNotBlank((CharSequence)pythonModulesDir)) {
            externalTypeCreator.pythonService = StandaloneCustomScriptManager.createPythonService(pythonModulesDir);
        }
        externalTypeCreator.customScriptService = standaloneCustomScriptService;
        this.log = LoggerFactory.getLogger(StandaloneCustomScriptManager.class);
        this.supportedCustomScriptTypes = new ArrayList();
        this.externalTypeCreator = externalTypeCreator;
        this.customScriptService = standaloneCustomScriptService;
    }

    private static PythonService createPythonService(String pythonModulesDir) {
        PythonService pythonService = new PythonService();
        pythonService.configure();
        pythonService.init();
        pythonService.initPythonInterpreter(pythonModulesDir);
        return pythonService;
    }

    public void init() {
        this.configure();
        this.reloadTimerEvent(null);
    }

    public void destroy() {
        super.destroy(null);
    }

    public void reload() {
        this.reloadTimerEvent(null);
    }

    public void registerExternalScriptService(ExternalScriptService externalScriptService) {
        externalScriptService.configure(this);
        this.externalScriptServices.add(externalScriptService);
        this.supportedCustomScriptTypes.add(externalScriptService.getCustomScriptType());
    }

    @Override
    public void updateScriptServices(boolean syncUpdate) {
        for (ExternalScriptService externalScriptService : this.externalScriptServices) {
            externalScriptService.reload(null);
        }
    }
}

