/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.custom.script.jit;

import io.jans.service.custom.script.jit.DiscardableClassLoader;
import io.jans.service.custom.script.jit.JavaCodeGenerator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJavaCompiler {
    private static final Logger log = LoggerFactory.getLogger(SimpleJavaCompiler.class);
    private final JavaCompiler compiler;
    private final StandardJavaFileManager standardJavaFileManager;
    private final DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector();
    private static final ThreadLocal<SimpleJavaCompiler> BY_THREAD = new ThreadLocal<SimpleJavaCompiler>(){

        @Override
        protected SimpleJavaCompiler initialValue() {
            return new SimpleJavaCompiler();
        }
    };
    public static volatile boolean dump = Boolean.getBoolean("compiler.java.dump");
    public static volatile String dumpDir = System.getProperty("compiler.java.dump.dir");
    private static String classpath;

    private SimpleJavaCompiler() {
        this.compiler = ToolProvider.getSystemJavaCompiler();
        this.standardJavaFileManager = this.compiler.getStandardFileManager(this.diagnostics, null, null);
    }

    public static <T> Class<? extends T> compile(Class<T> superClass, String source) {
        return BY_THREAD.get().compile0(superClass, source);
    }

    public static <T> Class<? extends T> compile(Class<T> superClass, Consumer<JavaCodeGenerator> sourceGen) {
        JavaCodeGenerator cg = new JavaCodeGenerator();
        sourceGen.accept(cg);
        StringWriter sw = new StringWriter();
        cg.generate(sw);
        Class<T> compiledClass = SimpleJavaCompiler.compile(superClass, sw.toString());
        SimpleJavaCompiler.dump(sw, compiledClass);
        return compiledClass;
    }

    private static void dump(StringWriter sw, Class<?> compiledClass) {
        if (dump) {
            System.out.println(sw);
        }
        if (dumpDir != null) {
            try {
                Files.write(Paths.get(dumpDir, compiledClass.getCanonicalName().replace('.', File.separatorChar) + ".java"), sw.toString().getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("unable to dump source file", e);
            }
        }
    }

    public static String getClasspath() {
        if (StringUtils.isBlank((CharSequence)classpath)) {
            URL[] urls = ((URLClassLoader)SimpleJavaCompiler.class.getClassLoader()).getURLs();
            StringBuilder sb = new StringBuilder(System.getProperty("java.class.path"));
            sb.append(File.pathSeparator);
            for (URL url : urls) {
                sb.append(url.toString()).append(File.pathSeparator);
            }
            classpath = SimpleJavaCompiler.fixClasspath(sb.toString());
        }
        return classpath;
    }

    private <T> Class<? extends T> compile0(Class<T> superClass, String source) {
        List<SourceFile> compilationUnits = Collections.singletonList(new SourceFile(SimpleJavaCompiler.toUri("Generated"), source));
        StringWriter output = new StringWriter();
        FileManager fileManager = new FileManager(this.standardJavaFileManager);
        String localClasspath = SimpleJavaCompiler.getClasspath();
        JavaCompiler.CompilationTask task = this.compiler.getTask(output, fileManager, this.diagnostics, Arrays.asList("-g", "-verbose", "-proc:none", "-classpath", localClasspath), null, compilationUnits);
        if (!task.call().booleanValue()) {
            log.error("Compilation diagnostics:");
            for (Diagnostic<JavaFileObject> diag : this.diagnostics.getDiagnostics()) {
                log.error(diag.getMessage(Locale.getDefault()));
            }
            log.error("Full classpath: {}", (Object)localClasspath);
            throw new IllegalArgumentException("Compilation failed:\n" + output + "\n Source code: \n" + source);
        }
        int classCount = fileManager.output.size();
        if (classCount == 1 || classCount > 0 && "CompiledStage".equals(((ClassFile)fileManager.output.get(0)).getName())) {
            return DiscardableClassLoader.classFromBytes(superClass, null, ((ClassFile)fileManager.output.get(0)).outputStream.toByteArray());
        }
        throw new IllegalArgumentException("Compilation yielded an unexpected number of classes: " + classCount);
    }

    public static String fixClasspath(String rawClasspath) {
        if (rawClasspath == null) {
            return null;
        }
        String cp = rawClasspath;
        cp = cp.replaceAll("[\\r\\n]", "");
        cp = cp.replaceAll("!/:jar", "");
        cp = cp.replaceAll(":jar:", ":");
        cp = cp.replaceAll("file:/+", "/");
        String sep = File.pathSeparator;
        String doubleSep = sep + sep;
        while (cp.contains(doubleSep)) {
            cp = cp.replace(doubleSep, sep);
        }
        return cp;
    }

    private static URI toUri(String path) {
        try {
            return new URI(null, null, path, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("exception parsing uri", e);
        }
    }

    private static class SourceFile
    extends SimpleJavaFileObject {
        private final String contents;

        private SourceFile(URI uri, String contents) {
            super(uri, JavaFileObject.Kind.SOURCE);
            this.contents = contents;
        }

        @Override
        public String getName() {
            return this.uri.getRawSchemeSpecificPart();
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            return true;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.contents;
        }
    }

    private static class FileManager
    extends ForwardingJavaFileManager<StandardJavaFileManager> {
        private List<ClassFile> output = new ArrayList<ClassFile>();

        FileManager(StandardJavaFileManager target) {
            super(target);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
            ClassFile file = new ClassFile(SimpleJavaCompiler.toUri(className));
            this.output.add(file);
            return file;
        }
    }

    private static class ClassFile
    extends SimpleJavaFileObject {
        private ByteArrayOutputStream outputStream;

        private ClassFile(URI uri) {
            super(uri, JavaFileObject.Kind.CLASS);
        }

        @Override
        public String getName() {
            return this.uri.getRawSchemeSpecificPart();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            this.outputStream = new ByteArrayOutputStream();
            return this.outputStream;
        }
    }
}

