/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.security;

import io.jans.service.security.InterceptSecure;
import io.jans.service.security.Secure;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecurityExtension
implements Extension {
    private Map<Method, InterceptSecure> interceptSecureForMethods = new HashMap<Method, InterceptSecure>();

    public <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> pat) {
        AnnotatedType at = pat.getAnnotatedType();
        AnnotatedTypeConfigurator cat = pat.configureAnnotatedType();
        ArrayList typeSecureAnnotations = new ArrayList();
        for (Annotation annotation : pat.getAnnotatedType().getAnnotations()) {
            this.collectAnnotations(Secure.class, annotation, typeSecureAnnotations);
        }
        for (AnnotatedMethodConfigurator methodConfiguration : cat.methods()) {
            AnnotatedMethod method = methodConfiguration.getAnnotated();
            ArrayList methodAnnotations = new ArrayList(typeSecureAnnotations);
            this.collectAnnotations(Secure.class, method, methodAnnotations);
            if (methodAnnotations.size() <= 0) continue;
            InterceptSecureImpl is = new InterceptSecureImpl(methodAnnotations.toArray(new Secure[methodAnnotations.size()]));
            methodConfiguration.add((Annotation)is);
            this.interceptSecureForMethods.put(method.getJavaMember(), is);
        }
    }

    private <T> void collectAnnotations(Class<T> annotationType, AnnotatedMethod<?> method, List<T> values) {
        for (Annotation annotation : method.getAnnotations()) {
            this.collectAnnotations(annotationType, annotation, values);
        }
    }

    private <T> void collectAnnotations(Class<T> annotationType, Annotation annotation, List<T> values) {
        if (annotationType.isAssignableFrom(annotation.annotationType())) {
            values.add(annotation);
        }
    }

    public InterceptSecure getInterceptSecure(Method method) {
        return this.interceptSecureForMethods.get(method);
    }

    private static class InterceptSecureImpl
    extends AnnotationLiteral<InterceptSecure>
    implements InterceptSecure {
        private final Secure[] values;

        InterceptSecureImpl(Secure[] values) {
            this.values = values;
        }

        @Override
        public Secure[] value() {
            return this.values;
        }
    }
}

