/*
 * Decompiled with CFR 0.152.
 */
package io.jans.oxtrust.auth.uma.annotations;

import io.jans.oxtrust.auth.uma.annotations.UmaSecure;
import io.jans.service.el.ExpressionEvaluator;
import io.jans.service.security.InterceptSecure;
import io.jans.service.security.Secure;
import io.jans.service.security.SecureVariable;
import io.jans.service.security.SecurityEvaluationException;
import io.jans.service.security.SecurityExtension;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

@Interceptor
@UmaSecure
@Priority(value=4000)
@Deprecated
public class UmaSecureInterceptor {
    @Inject
    private Logger log;
    @Inject
    private SecurityExtension securityExtension;
    @Inject
    private ExpressionEvaluator expressionEvaluator;

    @AroundInvoke
    public Object invoke(InvocationContext ctx) throws Exception {
        HttpServletResponse response = null;
        Object[] parameters = ctx.getParameters();
        this.log.trace("REST method call security check. " + ctx.getMethod().getName() + "()");
        for (Object object : parameters) {
            if (!(object instanceof HttpServletResponse)) continue;
            response = (HttpServletResponse)object;
        }
        InterceptSecure is = this.securityExtension.getInterceptSecure(ctx.getMethod());
        Secure[] constraints = is == null ? new Secure[]{} : is.value();
        Map<String, Object> secureVars = this.computeParameterValues(ctx);
        for (Secure constraint : constraints) {
            Boolean expressionValue = (Boolean)this.expressionEvaluator.evaluateValueExpression(constraint.value(), Boolean.class, secureVars);
            if (expressionValue != null && expressionValue.booleanValue()) continue;
            this.log.debug("Method: '{}' constrain '{}' evaluation is null or false!", (Object)ctx.getMethod(), (Object)constraint);
            throw new SecurityEvaluationException();
        }
        try {
            return ctx.proceed();
        }
        catch (Exception exception) {
            this.log.error("Error calling ctx.proceed in UmaSecureInterceptor");
            if (response != null) {
                try {
                    response.sendError(500, "INTERNAL SERVER ERROR");
                }
                catch (Exception exception2) {}
            } else if (Response.class.isAssignableFrom(ctx.getMethod().getReturnType())) {
                return Response.serverError().entity((Object)"INTERNAL SERVER ERROR").build();
            }
            return null;
        }
    }

    private Map<String, Object> computeParameterValues(InvocationContext ctx) {
        Annotation[][] parametersAnnotations = ctx.getMethod().getParameterAnnotations();
        HashMap<String, Object> secureVariables = new HashMap<String, Object>();
        for (int i = 0; i < parametersAnnotations.length; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation parameterAnnotation : parameterAnnotations = parametersAnnotations[i]) {
                if (!SecureVariable.class.isAssignableFrom(parameterAnnotation.annotationType())) continue;
                SecureVariable secureVariable = (SecureVariable)parameterAnnotation;
                Object paramValue = ctx.getParameters()[i];
                secureVariables.put(secureVariable.value(), paramValue);
            }
        }
        return secureVariables;
    }
}

