/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.security;

import io.jans.service.el.ExpressionEvaluator;
import io.jans.service.security.InterceptSecure;
import io.jans.service.security.Secure;
import io.jans.service.security.SecureVariable;
import io.jans.service.security.SecurityEvaluationException;
import io.jans.service.security.SecurityExtension;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

@Interceptor
@InterceptSecure(value={})
@Priority(value=4000)
public class SecurityInterceptor
implements Serializable {
    private static final long serialVersionUID = 8227941471496200128L;
    @Inject
    private Logger log;
    @Inject
    private SecurityExtension securityExtension;
    @Inject
    private ExpressionEvaluator expressionEvaluator;

    @AroundInvoke
    public Object invoke(InvocationContext ctx) throws Exception {
        InterceptSecure is = this.securityExtension.getInterceptSecure(ctx.getMethod());
        Secure[] constraints = is == null ? new Secure[]{} : is.value();
        Map<String, Object> secureVars = this.computeParameterValues(ctx);
        for (Secure constraint : constraints) {
            Boolean expressionValue = (Boolean)this.expressionEvaluator.evaluateValueExpression(constraint.value(), Boolean.class, secureVars);
            if (expressionValue != null && expressionValue.booleanValue()) continue;
            this.log.debug("Method: '{}' constrain '{}' evaluation is null or false!", (Object)ctx.getMethod(), (Object)constraint);
            throw new SecurityEvaluationException();
        }
        return ctx.proceed();
    }

    private Map<String, Object> computeParameterValues(InvocationContext ctx) {
        Annotation[][] parametersAnnotations = ctx.getMethod().getParameterAnnotations();
        HashMap<String, Object> secureVariables = new HashMap<String, Object>();
        for (int i = 0; i < parametersAnnotations.length; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation parameterAnnotation : parameterAnnotations = parametersAnnotations[i]) {
                if (!SecureVariable.class.isAssignableFrom(parameterAnnotation.annotationType())) continue;
                SecureVariable secureVariable = (SecureVariable)parameterAnnotation;
                Object paramValue = ctx.getParameters()[i];
                secureVariables.put(secureVariable.value(), paramValue);
            }
        }
        return secureVariables;
    }
}

