/*
 * Decompiled with CFR 0.152.
 */
package io.jans.server.filters;

import io.jans.server.filters.StringManager;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.slf4j.Logger;

public abstract class AbstractCorsFilter
implements Filter {
    @Inject
    private Logger log;
    private static final StringManager SM = StringManager.getManager("org.apache.catalina.filters");
    private Collection<String> allowedOrigins = new HashSet<String>();
    private final Collection<String> allowedHttpMethods = new HashSet<String>();
    private final Collection<String> allowedHttpHeaders = new HashSet<String>();
    private final Collection<String> exposedHeaders = new HashSet<String>();
    private boolean supportsCredentials;
    private long preflightMaxAge;
    private boolean decorateRequest;
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String REQUEST_HEADER_ORIGIN = "Origin";
    public static final String REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    public static final String HTTP_REQUEST_ATTRIBUTE_PREFIX = "cors.";
    public static final String HTTP_REQUEST_ATTRIBUTE_ORIGIN = "cors.request.origin";
    public static final String HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST = "cors.isCorsRequest";
    public static final String HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE = "cors.request.type";
    public static final String HTTP_REQUEST_ATTRIBUTE_REQUEST_HEADERS = "cors.request.headers";
    public static final Collection<String> HTTP_METHODS = new HashSet<String>(Arrays.asList("OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "CONNECT"));
    public static final Collection<String> COMPLEX_HTTP_METHODS = new HashSet<String>(Arrays.asList("PUT", "DELETE", "TRACE", "CONNECT"));
    public static final Collection<String> SIMPLE_HTTP_METHODS = new HashSet<String>(Arrays.asList("GET", "POST", "HEAD"));
    public static final Collection<String> SIMPLE_HTTP_REQUEST_HEADERS = new HashSet<String>(Arrays.asList("Accept", "Accept-Language", "Content-Language"));
    public static final Collection<String> SIMPLE_HTTP_RESPONSE_HEADERS = new HashSet<String>(Arrays.asList("Cache-Control", "Content-Language", "Content-Type", "Expires", "Last-Modified", "Pragma"));
    public static final Collection<String> SIMPLE_HTTP_REQUEST_CONTENT_TYPE_VALUES = new HashSet<String>(Arrays.asList("application/x-www-form-urlencoded", "multipart/form-data", "text/plain"));
    public static final String DEFAULT_ALLOWED_ORIGINS = "*";
    public static final String DEFAULT_ALLOWED_HTTP_METHODS = "GET,POST,HEAD,OPTIONS";
    public static final String DEFAULT_PREFLIGHT_MAXAGE = "1800";
    public static final String DEFAULT_SUPPORTS_CREDENTIALS = "true";
    public static final String DEFAULT_ALLOWED_HTTP_HEADERS = "Origin,Accept,X-Requested-With,Content-Type,Access-Control-Request-Method,Access-Control-Request-Headers";
    public static final String DEFAULT_EXPOSED_HEADERS = "";
    public static final String DEFAULT_DECORATE_REQUEST = "true";
    public static final String PARAM_CORS_ENABLED = "cors.enabled";
    public static final String PARAM_CORS_ALLOWED_ORIGINS = "cors.allowed.origins";
    public static final String PARAM_CORS_SUPPORT_CREDENTIALS = "cors.support.credentials";
    public static final String PARAM_CORS_EXPOSED_HEADERS = "cors.exposed.headers";
    public static final String PARAM_CORS_ALLOWED_HEADERS = "cors.allowed.headers";
    public static final String PARAM_CORS_ALLOWED_METHODS = "cors.allowed.methods";
    public static final String PARAM_CORS_PREFLIGHT_MAXAGE = "cors.preflight.maxage";
    public static final String PARAM_CORS_REQUEST_DECORATE = "cors.request.decorate";
    public static final String PARAM_CLIENT_ALLOWED_ORIGINS = "CLIENT_ALLOWED_ORIGINS";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            throw new ServletException(SM.getString("corsFilter.onlyHttp"));
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        CORSRequestType requestType = this.checkRequestType(request);
        this.dumpRequestDetails("before doFilter", request, requestType);
        if (this.decorateRequest) {
            this.decorateCORSProperties(request, requestType);
        }
        switch (requestType) {
            case SIMPLE: {
                this.handleSimpleCORS(request, response, filterChain);
                break;
            }
            case ACTUAL: {
                this.handleSimpleCORS(request, response, filterChain);
                break;
            }
            case PRE_FLIGHT: {
                this.handlePreflightCORS(request, response, filterChain);
                break;
            }
            case NOT_CORS: {
                this.handleNonCORS(request, response, filterChain);
                break;
            }
            default: {
                this.handleInvalidCORS(request, response, filterChain);
            }
        }
        this.dumpRequestDetails("after doFilter", request, requestType);
    }

    public abstract void init(FilterConfig var1) throws ServletException;

    protected void handleSimpleCORS(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        CORSRequestType requestType = this.checkRequestType(request);
        if (requestType != CORSRequestType.SIMPLE && requestType != CORSRequestType.ACTUAL) {
            throw new IllegalArgumentException(SM.getString("corsFilter.wrongType2", new Object[]{CORSRequestType.SIMPLE, CORSRequestType.ACTUAL}));
        }
        this.dumpRequestDetails("before handleSimpleCORS", request, requestType);
        String origin = request.getHeader(REQUEST_HEADER_ORIGIN);
        String method = request.getMethod();
        if (!this.isOriginAllowed((ServletRequest)request, origin)) {
            this.log.trace("handleSimpleCORS: handleInvalidCORS");
            this.handleInvalidCORS(request, response, filterChain);
            return;
        }
        if (!this.allowedHttpMethods.contains(method)) {
            this.log.trace("handleSimpleCORS: handleInvalidCORS");
            this.handleInvalidCORS(request, response, filterChain);
            return;
        }
        if (this.isAnyOriginAllowed((ServletRequest)request) && !this.supportsCredentials) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, DEFAULT_ALLOWED_ORIGINS);
        } else {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, origin);
        }
        if (this.supportsCredentials) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        }
        if (this.exposedHeaders != null && this.exposedHeaders.size() > 0) {
            String exposedHeadersString = AbstractCorsFilter.join(this.exposedHeaders, ",");
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_EXPOSE_HEADERS, exposedHeadersString);
        }
        this.dumpRequestDetails("after handleSimpleCORS", request, requestType);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected void handlePreflightCORS(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        CORSRequestType requestType = this.checkRequestType(request);
        if (requestType != CORSRequestType.PRE_FLIGHT) {
            throw new IllegalArgumentException(SM.getString("corsFilter.wrongType1", CORSRequestType.PRE_FLIGHT.name().toLowerCase()));
        }
        this.dumpRequestDetails("before handlePreflightCORS", request, requestType);
        String origin = request.getHeader(REQUEST_HEADER_ORIGIN);
        if (!this.isOriginAllowed((ServletRequest)request, origin)) {
            this.handleInvalidCORS(request, response, filterChain);
            return;
        }
        String accessControlRequestMethod = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD);
        if (accessControlRequestMethod == null || !HTTP_METHODS.contains(accessControlRequestMethod.trim())) {
            this.handleInvalidCORS(request, response, filterChain);
            return;
        }
        accessControlRequestMethod = accessControlRequestMethod.trim();
        String accessControlRequestHeadersHeader = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
        LinkedList<String> accessControlRequestHeaders = new LinkedList<String>();
        if (accessControlRequestHeadersHeader != null && !accessControlRequestHeadersHeader.trim().isEmpty()) {
            String[] headers;
            for (String header : headers = accessControlRequestHeadersHeader.trim().split(",")) {
                accessControlRequestHeaders.add(header.trim().toLowerCase());
            }
        }
        if (!this.allowedHttpMethods.contains(accessControlRequestMethod)) {
            this.handleInvalidCORS(request, response, filterChain);
            return;
        }
        if (!accessControlRequestHeaders.isEmpty()) {
            for (String header : accessControlRequestHeaders) {
                if (this.allowedHttpHeaders.contains(header)) continue;
                this.handleInvalidCORS(request, response, filterChain);
                return;
            }
        }
        if (this.supportsCredentials) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, origin);
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        } else if (this.isAnyOriginAllowed((ServletRequest)request)) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, DEFAULT_ALLOWED_ORIGINS);
        } else {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, origin);
        }
        if (this.preflightMaxAge > 0L) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_MAX_AGE, String.valueOf(this.preflightMaxAge));
        }
        response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_METHODS, accessControlRequestMethod);
        if (this.allowedHttpHeaders != null && !this.allowedHttpHeaders.isEmpty()) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_HEADERS, AbstractCorsFilter.join(this.allowedHttpHeaders, ","));
        }
        this.dumpRequestDetails("after handlePreflightCORS", request, requestType);
    }

    private void handleNonCORS(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void handleInvalidCORS(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) {
        String origin = request.getHeader(REQUEST_HEADER_ORIGIN);
        String method = request.getMethod();
        String accessControlRequestHeaders = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
        response.setContentType("text/plain");
        response.setStatus(403);
        response.resetBuffer();
        if (this.log.isDebugEnabled() || this.log.isTraceEnabled()) {
            StringBuilder message = new StringBuilder("Invalid CORS request; Origin=");
            message.append(origin);
            message.append(";Method=");
            message.append(method);
            if (accessControlRequestHeaders != null) {
                message.append(";Access-Control-Request-Headers=");
                message.append(accessControlRequestHeaders);
            }
            this.log.debug(message.toString());
        }
    }

    public void destroy() {
    }

    protected void decorateCORSProperties(HttpServletRequest request, CORSRequestType corsRequestType) {
        if (request == null) {
            throw new IllegalArgumentException(SM.getString("corsFilter.nullRequest"));
        }
        if (corsRequestType == null) {
            throw new IllegalArgumentException(SM.getString("corsFilter.nullRequestType"));
        }
        this.dumpRequestDetails("before decorateCORSProperties", request, corsRequestType);
        switch (corsRequestType) {
            case SIMPLE: {
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)Boolean.TRUE);
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_ORIGIN, (Object)request.getHeader(REQUEST_HEADER_ORIGIN));
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE, (Object)corsRequestType.name().toLowerCase());
                break;
            }
            case ACTUAL: {
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)Boolean.TRUE);
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_ORIGIN, (Object)request.getHeader(REQUEST_HEADER_ORIGIN));
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE, (Object)corsRequestType.name().toLowerCase());
                break;
            }
            case PRE_FLIGHT: {
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)Boolean.TRUE);
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_ORIGIN, (Object)request.getHeader(REQUEST_HEADER_ORIGIN));
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE, (Object)corsRequestType.name().toLowerCase());
                String headers = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
                if (headers == null) {
                    headers = DEFAULT_EXPOSED_HEADERS;
                }
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_HEADERS, (Object)headers);
                break;
            }
            case NOT_CORS: {
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)Boolean.FALSE);
                break;
            }
        }
        this.dumpRequestDetails("after decorateCORSProperties", request, corsRequestType);
    }

    protected static String join(Collection<String> elements, String joinSeparator) {
        String separator = ",";
        if (elements == null) {
            return null;
        }
        if (joinSeparator != null) {
            separator = joinSeparator;
        }
        StringBuilder buffer = new StringBuilder();
        boolean isFirst = true;
        for (String element : elements) {
            if (!isFirst) {
                buffer.append(separator);
            } else {
                isFirst = false;
            }
            if (element == null) continue;
            buffer.append(element);
        }
        return buffer.toString();
    }

    protected CORSRequestType checkRequestType(HttpServletRequest request) {
        CORSRequestType requestType = CORSRequestType.INVALID_CORS;
        if (request == null) {
            throw new IllegalArgumentException(SM.getString("corsFilter.nullRequest"));
        }
        String originHeader = request.getHeader(REQUEST_HEADER_ORIGIN);
        if (originHeader != null) {
            if (originHeader.isEmpty()) {
                requestType = CORSRequestType.INVALID_CORS;
            } else if (!AbstractCorsFilter.isValidOrigin(originHeader)) {
                requestType = CORSRequestType.INVALID_CORS;
            } else {
                String method = request.getMethod();
                if (method != null && HTTP_METHODS.contains(method)) {
                    if ("OPTIONS".equals(method)) {
                        String accessControlRequestMethodHeader = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD);
                        requestType = accessControlRequestMethodHeader != null && !accessControlRequestMethodHeader.isEmpty() ? CORSRequestType.PRE_FLIGHT : (accessControlRequestMethodHeader != null && accessControlRequestMethodHeader.isEmpty() ? CORSRequestType.INVALID_CORS : CORSRequestType.ACTUAL);
                    } else if ("GET".equals(method) || "HEAD".equals(method)) {
                        requestType = CORSRequestType.SIMPLE;
                    } else if ("POST".equals(method)) {
                        String contentType = request.getContentType();
                        if (contentType != null) {
                            requestType = SIMPLE_HTTP_REQUEST_CONTENT_TYPE_VALUES.contains(contentType = contentType.toLowerCase().trim()) ? CORSRequestType.SIMPLE : CORSRequestType.ACTUAL;
                        }
                    } else if (COMPLEX_HTTP_METHODS.contains(method)) {
                        requestType = CORSRequestType.ACTUAL;
                    }
                }
            }
        } else {
            requestType = CORSRequestType.NOT_CORS;
        }
        return requestType;
    }

    private boolean isOriginAllowed(ServletRequest servletRequest, String origin) {
        if (this.isAnyOriginAllowed(servletRequest)) {
            return true;
        }
        if (this.allowedOrigins != null && this.allowedOrigins.contains(origin)) {
            return true;
        }
        Collection<String> clientAllowedOrigins = this.getContextClientAllowedOrigins(servletRequest);
        return clientAllowedOrigins != null && clientAllowedOrigins.contains(origin);
    }

    protected void parseAndStore(String allowedOrigins, String allowedHttpMethods, String allowedHttpHeaders, String exposedHeaders, String supportsCredentials, String preflightMaxAge, String decorateRequest) throws ServletException {
        if (allowedOrigins != null && !allowedOrigins.trim().equals(DEFAULT_ALLOWED_ORIGINS)) {
            Set<String> setAllowedOrigins = this.parseStringToSet(allowedOrigins);
            this.allowedOrigins.clear();
            this.allowedOrigins.addAll(setAllowedOrigins);
        }
        if (allowedHttpMethods != null) {
            Set<String> setAllowedHttpMethods = this.parseStringToSet(allowedHttpMethods);
            this.allowedHttpMethods.clear();
            this.allowedHttpMethods.addAll(setAllowedHttpMethods);
        }
        if (allowedHttpHeaders != null) {
            Set<String> setAllowedHttpHeaders = this.parseStringToSet(allowedHttpHeaders);
            HashSet<String> lowerCaseHeaders = new HashSet<String>();
            for (String header : setAllowedHttpHeaders) {
                String lowerCase = header.toLowerCase();
                lowerCaseHeaders.add(lowerCase);
            }
            this.allowedHttpHeaders.clear();
            this.allowedHttpHeaders.addAll(lowerCaseHeaders);
        }
        if (exposedHeaders != null) {
            Set<String> setExposedHeaders = this.parseStringToSet(exposedHeaders);
            this.exposedHeaders.clear();
            this.exposedHeaders.addAll(setExposedHeaders);
        }
        if (supportsCredentials != null) {
            this.supportsCredentials = Boolean.parseBoolean(supportsCredentials);
        }
        if (preflightMaxAge != null) {
            try {
                this.preflightMaxAge = !preflightMaxAge.isEmpty() ? Long.parseLong(preflightMaxAge) : 0L;
            }
            catch (NumberFormatException e) {
                throw new ServletException(SM.getString("corsFilter.invalidPreflightMaxAge"), (Throwable)e);
            }
        }
        if (decorateRequest != null) {
            this.decorateRequest = Boolean.parseBoolean(decorateRequest);
        }
    }

    private Set<String> parseStringToSet(String data) {
        String[] splits = data != null && data.length() > 0 ? data.split(",") : new String[]{};
        HashSet<String> set = new HashSet<String>();
        if (splits.length > 0) {
            for (String split : splits) {
                set.add(split.trim());
            }
        }
        return set;
    }

    protected static boolean isValidOrigin(String origin) {
        URI originURI;
        if (origin.contains("%")) {
            return false;
        }
        try {
            originURI = new URI(origin);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return originURI.getScheme() != null;
    }

    public boolean isAnyOriginAllowed(ServletRequest servletRequest) {
        if (this.allowedOrigins != null && this.allowedOrigins.size() == 0) {
            if (!this.hasContextClientAllowedOrigins(servletRequest)) {
                return true;
            }
            Collection<String> clientAllowedOrigins = this.getContextClientAllowedOrigins(servletRequest);
            if (clientAllowedOrigins != null && clientAllowedOrigins.size() == 0) {
                return true;
            }
        }
        return false;
    }

    protected void setContextClientAllowedOrigins(ServletRequest servletRequest, Collection<String> clientAllowedOrigins) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("setContextClientAllowedOrigins: {}", clientAllowedOrigins);
        }
        servletRequest.setAttribute(PARAM_CLIENT_ALLOWED_ORIGINS, clientAllowedOrigins);
    }

    protected Collection<String> getContextClientAllowedOrigins(ServletRequest servletRequest) {
        return (Collection)servletRequest.getAttribute(PARAM_CLIENT_ALLOWED_ORIGINS);
    }

    protected boolean hasContextClientAllowedOrigins(ServletRequest servletRequest) {
        Enumeration attributeNames = servletRequest.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            if (!PARAM_CLIENT_ALLOWED_ORIGINS.equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    private void dumpRequestDetails(String prefix, HttpServletRequest request, CORSRequestType corsRequestType) {
        if (!this.log.isTraceEnabled()) {
            return;
        }
        StringBuilder allAttributes = new StringBuilder("[");
        Iterator it = request.getAttributeNames().asIterator();
        while (it.hasNext()) {
            if (allAttributes.length() > 1) {
                allAttributes.append(",");
            }
            String attributeName = (String)it.next();
            allAttributes.append(attributeName).append(" = ").append(request.getAttribute(attributeName));
        }
        allAttributes.append("]");
        StringBuilder allHeaders = new StringBuilder("[");
        Iterator it2 = request.getHeaderNames().asIterator();
        while (it2.hasNext()) {
            if (allHeaders.length() > 1) {
                allHeaders.append(",");
            }
            String HeaderName = (String)it2.next();
            allHeaders.append(HeaderName).append(" = ").append(request.getHeader(HeaderName));
        }
        allHeaders.append("]");
        this.log.trace("{}: request method {} to URI {}, corsType {}, attributes {}, headers {}", new Object[]{prefix, request.getMethod(), request.getRequestURI(), corsRequestType, allAttributes, allHeaders});
    }

    public Collection<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public boolean isSupportsCredentials() {
        return this.supportsCredentials;
    }

    public long getPreflightMaxAge() {
        return this.preflightMaxAge;
    }

    public Collection<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(Collection<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public Collection<String> getAllowedHttpMethods() {
        return this.allowedHttpMethods;
    }

    public Collection<String> getAllowedHttpHeaders() {
        return this.allowedHttpHeaders;
    }

    protected static enum CORSRequestType {
        SIMPLE,
        ACTUAL,
        PRE_FLIGHT,
        NOT_CORS,
        INVALID_CORS;

    }
}

