/*
 * Decompiled with CFR 0.152.
 */
package io.jans.model.security;

import io.jans.model.security.Credentials;
import io.jans.model.security.SimplePrincipal;
import io.jans.model.security.event.Authenticated;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Alternative;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;

@RequestScoped
@Named
@Alternative
@Priority(value=2010)
public class Identity
implements Serializable {
    private static final long serialVersionUID = 3751659008033189259L;
    public static final String EVENT_LOGIN_SUCCESSFUL = "org.jboss.seam.security.loginSuccessful";
    public static final String ROLES_GROUP = "Roles";
    @Inject
    private Logger log;
    @Inject
    private Credentials credentials;
    @Inject
    private Event<String> event;
    private Principal principal;
    private HashMap<String, Object> workingParameters;
    private Subject subject;

    @PostConstruct
    public void create() {
        this.subject = new Subject();
    }

    public boolean isLoggedIn() {
        return this.getPrincipal() != null;
    }

    public boolean tryLogin() {
        if (this.getPrincipal() == null && this.credentials.isSet()) {
            this.quietLogin();
        }
        return this.isLoggedIn();
    }

    public String login() {
        try {
            if (this.isLoggedIn()) {
                return "loggedIn";
            }
            this.authenticate();
            if (!this.isLoggedIn()) {
                throw new LoginException();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Login successful for: " + this.credentials.getUsername());
            }
            this.event.select(new Annotation[]{Authenticated.Literal.INSTANCE}).fire((Object)EVENT_LOGIN_SUCCESSFUL);
            return "loggedIn";
        }
        catch (LoginException ex) {
            this.credentials.invalidate();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Login failed for: " + this.credentials.getUsername(), (Throwable)ex);
            }
            return null;
        }
    }

    public void quietLogin() {
        try {
            if (!this.isLoggedIn() && this.credentials.isSet()) {
                this.authenticate();
            }
        }
        catch (LoginException ex) {
            this.credentials.invalidate();
        }
    }

    public synchronized void authenticate() throws LoginException {
        if (!this.isLoggedIn() && !this.credentials.isInvalid()) {
            this.principal = new SimplePrincipal(this.credentials.getUsername());
            this.credentials.setPassword(null);
        }
    }

    public void acceptExternallyAuthenticatedPrincipal(Principal principal) {
        this.principal = principal;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void unAuthenticate() {
        this.principal = null;
        this.credentials.clear();
        this.subject = new Subject();
    }

    public void logout() {
        if (this.isLoggedIn()) {
            this.unAuthenticate();
        }
    }

    private synchronized void initWorkingParamaters() {
        if (this.workingParameters == null) {
            this.workingParameters = new HashMap();
        }
    }

    public HashMap<String, Object> getWorkingParameters() {
        this.initWorkingParamaters();
        return this.workingParameters;
    }

    public boolean isSetWorkingParameter(String name) {
        return this.getWorkingParameters().containsKey(name);
    }

    public Object getWorkingParameter(String name) {
        return this.getWorkingParameters().get(name);
    }

    public void setWorkingParameter(String name, Object value) {
        this.getWorkingParameters().put(name, value);
    }
}

