/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service;

import io.jans.model.user.SimpleUser;
import io.jans.model.user.authenticator.UserAuthenticator;
import io.jans.model.user.authenticator.UserAuthenticatorList;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

@ApplicationScoped
public class UserAuthenticatorService {
    @Inject
    private Logger log;
    public static String EXTERNAL_UID_FORMAT = "%s:%s";
    private static String[] EMPTY_STRING_ARRAY = new String[0];
    private static final UserAuthenticatorList EMPTY_USER_AUTHENTICATOR_LIST = new UserAuthenticatorList(Collections.emptyList());

    public UserAuthenticatorList getUserAuthenticatorList(SimpleUser user) {
        if (user == null || user.getAuthenticator() == null || user.getAuthenticator().getAuthenticators() == null) {
            return EMPTY_USER_AUTHENTICATOR_LIST;
        }
        return user.getAuthenticator();
    }

    public List<UserAuthenticator> getUserAuthenticatorsByType(SimpleUser user, String type) {
        UserAuthenticatorList userAuthenticatorList = this.getUserAuthenticatorList(user);
        ArrayList<UserAuthenticator> result = new ArrayList<UserAuthenticator>();
        for (UserAuthenticator authenticator : userAuthenticatorList.getAuthenticators()) {
            if (!authenticator.getType().equals(type)) continue;
            result.add(authenticator);
        }
        return result;
    }

    public UserAuthenticator getUserAuthenticatorById(SimpleUser user, String id) {
        UserAuthenticatorList userAuthenticatorList = this.getUserAuthenticatorList(user);
        for (UserAuthenticator authenticator : userAuthenticatorList.getAuthenticators()) {
            if (!authenticator.getId().equals(id)) continue;
            return authenticator;
        }
        return null;
    }

    public void addUserAuthenticator(SimpleUser user, UserAuthenticator userAuthenticator) {
        UserAuthenticatorList userAuthenticatorList = user.getAuthenticator();
        if (userAuthenticatorList == null) {
            user.setAuthenticator(new UserAuthenticatorList());
        }
        user.getAuthenticator().addAuthenticator(userAuthenticator);
        String externalUid = String.format(EXTERNAL_UID_FORMAT, userAuthenticator.getType(), userAuthenticator.getId());
        ArrayList<String> externalUidList = new ArrayList<String>();
        if (user.getExternalUid() != null) {
            externalUidList.addAll(Arrays.asList(user.getExternalUid()));
        }
        externalUidList.add(externalUid);
        user.setExternalUid(externalUidList.toArray(EMPTY_STRING_ARRAY));
    }

    public void removeUserAuthenticator(SimpleUser user, UserAuthenticator userAuthenticator) {
        UserAuthenticatorList userAuthenticatorList = user.getAuthenticator();
        if (userAuthenticatorList != null) {
            Iterator it = userAuthenticatorList.getAuthenticators().iterator();
            while (it.hasNext()) {
                UserAuthenticator authenticator = (UserAuthenticator)it.next();
                if (!userAuthenticator.getId().equals(authenticator.getId()) || !userAuthenticator.getType().equals(authenticator.getType())) continue;
                it.remove();
                break;
            }
            if (userAuthenticatorList.getAuthenticators().size() == 0) {
                user.setAuthenticator(null);
            }
        }
        ArrayList<String> externalUidList = new ArrayList<String>();
        if (user.getExternalUid() != null) {
            externalUidList.addAll(Arrays.asList(user.getExternalUid()));
            Iterator it = externalUidList.iterator();
            while (it.hasNext()) {
                String externalUid = (String)it.next();
                int idx = externalUid.indexOf(58);
                if (idx == -1) continue;
                String foundType = externalUid.substring(0, idx).trim();
                String id = externalUid.substring(idx + 1).trim();
                if (!userAuthenticator.getId().equals(id) || !userAuthenticator.getType().equals(foundType)) continue;
                it.remove();
                break;
            }
            if (externalUidList.size() == 0) {
                user.setExternalUid(null);
            } else {
                user.setExternalUid(externalUidList.toArray(EMPTY_STRING_ARRAY));
            }
        }
    }

    public void removeUserAuthenticator(SimpleUser user, String type) {
        UserAuthenticatorList userAuthenticatorList = user.getAuthenticator();
        if (userAuthenticatorList != null) {
            Iterator it = userAuthenticatorList.getAuthenticators().iterator();
            while (it.hasNext()) {
                UserAuthenticator authenticator = (UserAuthenticator)it.next();
                if (!type.equals(authenticator.getType())) continue;
                it.remove();
            }
            if (userAuthenticatorList.getAuthenticators().size() == 0) {
                user.setAuthenticator(null);
            }
        }
        ArrayList<String> externalUidList = new ArrayList<String>();
        if (user.getExternalUid() != null) {
            externalUidList.addAll(Arrays.asList(user.getExternalUid()));
            Iterator it = externalUidList.iterator();
            while (it.hasNext()) {
                String foundType;
                String externalUid = (String)it.next();
                int idx = externalUid.indexOf(58);
                if (idx == -1 || !type.equals(foundType = externalUid.substring(0, idx).trim())) continue;
                it.remove();
            }
            if (externalUidList.size() == 0) {
                user.setExternalUid(null);
            } else {
                user.setExternalUid(externalUidList.toArray(EMPTY_STRING_ARRAY));
            }
        }
    }

    public UserAuthenticator createUserAuthenticator(String id, String type) {
        return this.createUserAuthenticator(id, type, null);
    }

    public UserAuthenticator createUserAuthenticator(String id, String type, Map<String, Object> custom) {
        UserAuthenticator userAuthenticator = new UserAuthenticator(id, type);
        userAuthenticator.setCustom(custom);
        return userAuthenticator;
    }

    public String formatExternalUid(String id, String type) {
        String externalUid = String.format(EXTERNAL_UID_FORMAT, type, id);
        return externalUid;
    }

    public boolean checkAndMigrateToAuthenticatorList(SimpleUser user) {
        if (user.getExternalUid() == null) {
            return false;
        }
        UserAuthenticatorList userAuthenticatorList = user.getAuthenticator();
        if (userAuthenticatorList != null && userAuthenticatorList.getAuthenticators() != null && userAuthenticatorList.getAuthenticators().size() > 0) {
            return false;
        }
        ArrayList<String> externalUidList = new ArrayList<String>();
        externalUidList.addAll(Arrays.asList(user.getExternalUid()));
        for (String externalUid : user.getExternalUid()) {
            int idx = externalUid.indexOf(58);
            if (idx == -1) continue;
            String type = externalUid.substring(0, idx).trim();
            String id = externalUid.substring(idx + 1).trim();
            UserAuthenticator authenticator = this.createUserAuthenticator(id, type);
            this.addUserAuthenticator(user, authenticator);
        }
        return true;
    }
}

