/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service;

import io.jans.exception.ConfigurationException;
import io.jans.util.properties.FileConfiguration;
import jakarta.inject.Inject;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public abstract class ApplicationConfigurationFactory {
    @Inject
    private Logger log;
    private AtomicBoolean isCreated = new AtomicBoolean(false);

    public void create() {
        if (this.isCreated.get()) {
            return;
        }
        if (!this.isCreated.compareAndSet(false, true)) {
            return;
        }
        try {
            if (!this.createFromDB(true)) {
                this.log.error("Failed to load configuration from DB. Please fix it!!!.");
                throw new ConfigurationException("Failed to load configuration from DB.");
            }
            this.log.info("Configuration loaded successfully.");
        }
        finally {
            this.isCreated.set(true);
        }
    }

    protected abstract boolean createFromDB(boolean var1);

    public void initTimer() {
    }

    public abstract FileConfiguration getBaseConfiguration();
}

