/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service;

import io.jans.util.StringHelper;
import jakarta.faces.FacesException;
import jakarta.faces.view.facelets.ResourceResolver;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalResourceHandler
extends ResourceResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalResourceHandler.class);
    private ResourceResolver parent;
    private File externalResourceBaseFolder;
    private boolean useExternalResourceBase;
    private Map<String, Boolean> pagesUpdateByViewId;

    public ExternalResourceHandler(ResourceResolver parent) {
        this.parent = parent;
        this.pagesUpdateByViewId = Collections.synchronizedMap(new HashMap());
        Object externalResourceBase = System.getProperty("server.base");
        if (StringHelper.isNotEmpty((String)externalResourceBase)) {
            File folder = new File((String)(externalResourceBase = (String)externalResourceBase + "/custom/pages"));
            if (folder.exists() && folder.isDirectory()) {
                this.externalResourceBaseFolder = folder;
                this.useExternalResourceBase = true;
            } else {
                LOG.error("Specified path '" + (String)externalResourceBase + "' in 'server.base' not exists or not a folder!");
            }
        }
    }

    public URL resolveUrl(String path) {
        if (!this.useExternalResourceBase) {
            return this.parent.resolveUrl(path);
        }
        File externalResource = new File(this.externalResourceBaseFolder, path);
        if (externalResource.exists()) {
            try {
                LOG.debug("Found overriden resource: " + path);
                URL resource = externalResource.toURI().toURL();
                return resource;
            }
            catch (MalformedURLException ex) {
                throw new FacesException((Throwable)ex);
            }
        }
        return this.parent.resolveUrl(path);
    }

    public String toString() {
        return "ExternalResourceHandler";
    }
}

