/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.security.protect;

import io.jans.model.security.protect.AuthenticationAttempt;
import io.jans.model.security.protect.AuthenticationAttemptList;
import io.jans.service.CacheService;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.List;
import org.slf4j.Logger;

public abstract class AuthenticationProtectionService {
    @Inject
    private CacheService cacheService;
    @Inject
    private Logger log;
    protected int attemptExpiration;
    protected int maximumAllowedAttemptsWithoutDelay;
    protected int delayTime;

    @PostConstruct
    public void create() {
        this.init();
    }

    protected abstract void init();

    public void storeAttempt(String key, boolean success) {
        AuthenticationAttemptList authenticationAttemptList = this.getNonExpiredAttempts(key);
        if (authenticationAttemptList == null) {
            authenticationAttemptList = new AuthenticationAttemptList();
        }
        long currentTime = System.currentTimeMillis();
        AuthenticationAttempt authenticationAttempt = new AuthenticationAttempt(currentTime, currentTime + (long)(this.attemptExpiration * 1000), success);
        authenticationAttemptList.getAuthenticationAttempts().add(authenticationAttempt);
        this.cacheService.put(Integer.toString(this.attemptExpiration), this.buildKey(key), (Object)authenticationAttemptList);
    }

    public AuthenticationAttemptList getAttempts(String key) {
        Object o = this.cacheService.get(null, this.buildKey(key));
        if (o instanceof AuthenticationAttemptList) {
            return (AuthenticationAttemptList)o;
        }
        return null;
    }

    public AuthenticationAttemptList getNonExpiredAttempts(String key) {
        AuthenticationAttemptList authenticationAttemptList = this.getAttempts(key);
        if (authenticationAttemptList == null) {
            return null;
        }
        long currentTime = System.currentTimeMillis();
        AuthenticationAttemptList result = new AuthenticationAttemptList();
        List<AuthenticationAttempt> resultAuthenticationAttemptList = result.getAuthenticationAttempts();
        for (AuthenticationAttempt authenticationAttempt : authenticationAttemptList.getAuthenticationAttempts()) {
            if (authenticationAttempt.getExpiration() <= currentTime) continue;
            resultAuthenticationAttemptList.add(authenticationAttempt);
        }
        return result;
    }

    public boolean isReachAttemptRateLimit(String key) {
        AuthenticationAttemptList authenticationAttemptList = this.getNonExpiredAttempts(key);
        if (authenticationAttemptList == null) {
            return false;
        }
        return authenticationAttemptList.getAuthenticationAttempts().size() >= this.maximumAllowedAttemptsWithoutDelay;
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public void doDelayIfNeeded(String key) {
        boolean processDelay = this.isReachAttemptRateLimit(key);
        if (!processDelay) {
            this.log.debug("Allowing current login attempt without delay");
            return;
        }
        int delayTime = this.getDelayTime();
        try {
            this.log.debug("Current login attempt requires delay: '{}' seconds", (Object)delayTime);
            Thread.sleep(delayTime * 1000);
        }
        catch (InterruptedException ex) {
            this.log.error("Failed to process authentication delay");
        }
    }

    private String buildKey(String key) {
        return this.getKeyPrefix() + "_" + key.toLowerCase();
    }

    protected abstract String getKeyPrefix();
}

