/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.cdi.async;

import io.jans.service.cdi.async.Asynchronous;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

@Interceptor
@Asynchronous
@Priority(value=0)
public class AsynchronousInterceptor
implements Serializable {
    private static final long serialVersionUID = 4839412676894893540L;
    private static final ThreadLocal<Boolean> ASYNC_INVOCATION = new ThreadLocal();

    @AroundInvoke
    public Object invoke(InvocationContext ctx) throws Exception {
        if (Boolean.TRUE.equals(ASYNC_INVOCATION.get())) {
            return ctx.proceed();
        }
        final InvocationContext localCtx = ctx;
        return CompletableFuture.supplyAsync(new Supplier<Object>(){

            @Override
            public Object get() {
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                try {
                    ASYNC_INVOCATION.set(Boolean.TRUE);
                    Object object = localCtx.proceed();
                    return object;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                    ASYNC_INVOCATION.remove();
                }
                return null;
            }
        });
    }
}

