/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.cdi.util;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CdiUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CdiUtil.class);

    private CdiUtil() {
    }

    public static <T> T getContextBean(BeanManager beanManager, Type type, String beanName, Annotation ... qualifiers) {
        NamedLiteral namedLiteral = NamedLiteral.of((String)beanName);
        Annotation[] allQualifiers = null;
        allQualifiers = qualifiers == null ? new Annotation[]{namedLiteral} : (Annotation[])ArrayUtils.add((Object[])qualifiers, (Object)namedLiteral);
        Bean bean = beanManager.resolve(beanManager.getBeans(type, qualifiers));
        if (bean == null) {
            return null;
        }
        Object existingInstance = beanManager.getContext(bean.getScope()).get((Contextual)bean, beanManager.createCreationalContext((Contextual)bean));
        return (T)existingInstance;
    }

    public static <T> Instance<T> instance(Class<T> clazz) {
        return CDI.current().select(clazz, new Annotation[0]);
    }

    public static <T> Instance<T> instance(Class<T> clazz, String name) {
        return CDI.current().select(clazz, new Annotation[]{NamedLiteral.of((String)name)});
    }

    public static <T> T bean(Class<T> clazz) {
        return (T)CdiUtil.instance(clazz).get();
    }

    public static <T> T bean(Class<T> clazz, String name) {
        return (T)CdiUtil.instance(clazz, name).get();
    }

    public static <T> void destroy(Class<T> clazz) {
        Instance<T> instance = CdiUtil.instance(clazz);
        if (instance.isResolvable()) {
            instance.destroy(instance.get());
        }
    }

    public static <T> T destroy(Class<T> clazz, String name) {
        Instance<T> instance = CdiUtil.instance(clazz, name);
        if (instance.isResolvable()) {
            Object obj = instance.get();
            instance.destroy(obj);
            return (T)obj;
        }
        return null;
    }
}

