/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.cluster;

import io.jans.exception.ConfigurationException;
import io.jans.model.cluster.ClusterNode;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.search.filter.Filter;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class ClusterNodeService {
    public static final int ATTEMPT_LIMIT = 10;
    public static final long DELAY_AFTER_EXPIRATION = 180000L;
    public static final String JANS_TYPE_ATTR_NAME = "jansType";
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager entryManager;

    public ClusterNode getClusterNodeByDn(String dn) {
        return (ClusterNode)((Object)this.entryManager.find(ClusterNode.class, (Object)dn));
    }

    public ClusterNode getClusterNodeById(Integer id) {
        return (ClusterNode)((Object)this.entryManager.find(ClusterNode.class, (Object)this.getDnForClusterNode(id)));
    }

    public List<ClusterNode> getAllClusterNodes() {
        String clusterNodesBaseDn = this.getBaseClusterNodeDn();
        return this.entryManager.findEntries(clusterNodesBaseDn, ClusterNode.class, this.getTypeFilter());
    }

    public List<String> getClusterNodesDns(List<Integer> nodeIds) {
        ArrayList<String> clusterNodesDns = new ArrayList<String>();
        for (Integer nodeId : nodeIds) {
            ClusterNode clusterNode = this.getClusterNodeById(nodeId);
            if (clusterNode == null) continue;
            clusterNodesDns.add(clusterNode.getDn());
        }
        return clusterNodesDns;
    }

    public ClusterNode getClusterNodeLast() {
        PagedResult pagedResult;
        String clusterNodesBaseDn = this.getBaseClusterNodeDn();
        int count = 1;
        if (PersistenceEntryManager.PERSITENCE_TYPES.ldap.name().equals(this.entryManager.getPersistenceType(clusterNodesBaseDn))) {
            count = Integer.MAX_VALUE;
        }
        if ((pagedResult = this.entryManager.findPagedEntries(clusterNodesBaseDn, ClusterNode.class, Filter.createEqualityFilter((String)JANS_TYPE_ATTR_NAME, (Object)this.getClusterNodeType()), null, "jansNum", SortOrder.DESCENDING, 0, count, count)).getEntriesCount() >= 1) {
            return (ClusterNode)((Object)pagedResult.getEntries().get(0));
        }
        return null;
    }

    public List<ClusterNode> getClusterNodesExpired() {
        String clusterNodesBaseDn = this.getBaseClusterNodeDn();
        if (StringUtils.isBlank((CharSequence)clusterNodesBaseDn)) {
            throw new ConfigurationException("ou=node is not configured in static configuration of AS (jansConfStatic).");
        }
        Date expirationDate = new Date(System.currentTimeMillis() - 180000L);
        Filter filter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)JANS_TYPE_ATTR_NAME, (Object)this.getClusterNodeType()), Filter.createORFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"jansLastUpd", null), Filter.createLessOrEqualFilter((String)"jansLastUpd", (Object)this.entryManager.encodeTime(clusterNodesBaseDn, expirationDate))})});
        return this.entryManager.findEntries(clusterNodesBaseDn, ClusterNode.class, filter);
    }

    public List<ClusterNode> getClusterNodesLive() {
        String clusterNodesBaseDn = this.getBaseClusterNodeDn();
        if (StringUtils.isBlank((CharSequence)clusterNodesBaseDn)) {
            throw new ConfigurationException("ou=node is not configured in static configuration of AS (jansConfStatic).");
        }
        Date expirationDate = new Date(System.currentTimeMillis() - 180000L);
        Filter filter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)JANS_TYPE_ATTR_NAME, (Object)this.getClusterNodeType()), Filter.createGreaterOrEqualFilter((String)"jansLastUpd", (Object)this.entryManager.encodeTime(clusterNodesBaseDn, expirationDate))});
        return this.entryManager.findEntries(clusterNodesBaseDn, ClusterNode.class, filter);
    }

    @NotNull
    private Filter getTypeFilter() {
        return Filter.createEqualityFilter((String)JANS_TYPE_ATTR_NAME, (Object)this.getClusterNodeType());
    }

    protected void persist(ClusterNode clusterNode) {
        this.entryManager.persist((Object)clusterNode);
    }

    public void update(ClusterNode clusterNode) {
        this.entryManager.merge((Object)clusterNode);
    }

    public ClusterNode allocate() {
        this.log.info("Allocating node, getLockKey() {}... ", (Object)this.getLockKey());
        List<ClusterNode> expiredNodes = this.getClusterNodesExpired();
        this.log.info("Allocation - found {} expired nodes.", (Object)expiredNodes.size());
        for (ClusterNode expiredNode : expiredNodes) {
            try {
                Date currentTime = new Date();
                expiredNode.setCreationDate(currentTime);
                expiredNode.setLastUpdate(currentTime);
                expiredNode.setLockKey(this.getLockKey());
                this.update(expiredNode);
                ClusterNode lockedNode = this.getClusterNodeByDn(expiredNode.getDn());
                if (this.getLockKey().equals(lockedNode.getLockKey())) {
                    this.log.info("Re-using existing node {}, getLockKey() {}", (Object)lockedNode.getId(), (Object)this.getLockKey());
                    return lockedNode;
                }
                this.log.info("Failed to lock node {}, getLockKey() {}", (Object)lockedNode.getId(), (Object)this.getLockKey());
            }
            catch (EntryPersistenceException ex) {
                this.log.debug("Unexpected error happened during entry lock", (Throwable)ex);
            }
        }
        int attempt = 1;
        do {
            this.log.info("Attempting to persist new node. Attempt {} out of {} ...", (Object)attempt, (Object)10);
            ClusterNode lastClusterNode = this.getClusterNodeLast();
            this.log.info("lastClusterNode - {}, getLockKey() {}", (Object)(lastClusterNode != null ? lastClusterNode.getId() : -1), (Object)this.getLockKey());
            Integer lastClusterNodeIndex = lastClusterNode == null ? 0 : lastClusterNode.getId() + 1;
            Date currentTime = new Date();
            ClusterNode node = new ClusterNode();
            node.setId(lastClusterNodeIndex);
            node.setDn(this.getDnForClusterNode(lastClusterNodeIndex));
            node.setCreationDate(currentTime);
            node.setLastUpdate(currentTime);
            node.setType(this.getClusterNodeType());
            node.setLockKey(this.getLockKey());
            try {
                this.persist(node);
                ClusterNode lockedNode = this.getClusterNodeByDn(node.getDn());
                if (this.getLockKey().equals(lockedNode.getLockKey())) {
                    this.log.info("Successfully created new cluster node {}", (Object)node);
                    return lockedNode;
                }
                this.log.info("Locked key does not match. nodeLockKey {} of node {}", (Object)lockedNode.getLockKey(), (Object)lockedNode.getId());
            }
            catch (EntryPersistenceException ex) {
                this.log.debug("Unexpected error happened during entry lock, getLockKey() " + this.getLockKey(), (Throwable)ex);
            }
        } while (++attempt <= 10);
        return null;
    }

    public void refresh(ClusterNode node) {
        node.setLastUpdate(new Date());
        this.log.trace("Refreshing node: {}", (Object)node);
        this.update(node);
    }

    public ClusterNode reset(ClusterNode node) {
        Date currentTime = new Date();
        node.setCreationDate(currentTime);
        node.setLastUpdate(currentTime);
        this.log.trace("Resetting node: {}", (Object)node);
        this.update(node);
        return node;
    }

    public abstract String getLockKey();

    public abstract String getClusterNodeType();

    public abstract String getBaseClusterNodeDn();

    public String getDnForClusterNode(Integer id) {
        return String.format("jansNum=%d,%s", id, this.getBaseClusterNodeDn());
    }
}

