/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service;

import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import io.jans.model.JansAttribute;
import io.jans.model.SchemaEntry;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.search.filter.Filter;
import io.jans.service.BaseCacheService;
import io.jans.service.CacheService;
import io.jans.service.LocalCacheService;
import io.jans.service.SchemaService;
import io.jans.util.StringHelper;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public abstract class AttributeService
implements Serializable {
    private static final long serialVersionUID = -1311784648561611479L;
    @Inject
    protected Logger log;
    @Inject
    protected PersistenceEntryManager persistenceEntryManager;
    @Inject
    protected SchemaService schemaService;
    @Inject
    protected CacheService cacheService;
    @Inject
    protected LocalCacheService localCacheService;

    public List<JansAttribute> getAttributesByAttribute(String attributeName, String attributeValue, String baseDn) {
        Filter filter = Filter.createEqualityFilter((String)attributeName, (Object)attributeValue);
        List result = this.persistenceEntryManager.findEntries(baseDn, JansAttribute.class, filter);
        return result;
    }

    public String getDefaultSaml2Uri(String name) {
        SchemaEntry schemaEntry = this.schemaService.getSchema();
        if (schemaEntry == null) {
            ArrayList<String> attributeNames = new ArrayList<String>();
            attributeNames.add(name);
            List<AttributeTypeDefinition> attributeTypes = this.schemaService.getAttributeTypeDefinitions(schemaEntry, attributeNames);
            AttributeTypeDefinition attributeTypeDefinition = this.schemaService.getAttributeTypeDefinition(attributeTypes, name);
            if (attributeTypeDefinition != null) {
                return String.format("urn:oid:%s", attributeTypeDefinition.getOID());
            }
        }
        return "";
    }

    public JansAttribute getAttributeByName(String name) {
        return this.getAttributeByName(name, this.getAllAttributes());
    }

    public JansAttribute getAttributeByName(String name, List<JansAttribute> attributes) {
        for (JansAttribute attribute : attributes) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    public JansAttribute getAttributeByInum(String inum) {
        return this.getAttributeByInum(inum, this.getAllAtributesImpl(this.getDnForAttribute(null)));
    }

    public JansAttribute getAttributeByInum(String inum, List<JansAttribute> attributes) {
        for (JansAttribute attribute : attributes) {
            if (!attribute.getInum().equals(inum)) continue;
            return attribute;
        }
        return null;
    }

    public List<JansAttribute> getAllAttributes() {
        return this.getAllAttributes(this.getDnForAttribute(null));
    }

    public List<JansAttribute> getAllAttributes(String baseDn) {
        BaseCacheService usedCacheService = this.getCacheService();
        List<JansAttribute> attributeList = (List<JansAttribute>)usedCacheService.get("AttributeCache", "attributeList");
        if (attributeList == null) {
            attributeList = this.getAllAtributesImpl(baseDn);
            usedCacheService.put("AttributeCache", "attributeList", attributeList);
        }
        return attributeList;
    }

    public Map<String, JansAttribute> getAllAttributesMap() {
        return this.getAllAttributesMap(this.getDnForAttribute(null));
    }

    public Map<String, JansAttribute> getAllAttributesMap(String baseDn) {
        BaseCacheService usedCacheService = this.getCacheService();
        Map<String, JansAttribute> attributeMap = (Map<String, JansAttribute>)usedCacheService.get("AttributeCache", "attributeMap");
        if (attributeMap == null) {
            attributeMap = this.getAllAttributesMapImpl(baseDn);
            usedCacheService.put("AttributeCache", "attributeMap", attributeMap);
        }
        return attributeMap;
    }

    private Map<String, JansAttribute> getAllAttributesMapImpl(String baseDn) {
        List<JansAttribute> attributeList = this.getAllAttributes(baseDn);
        HashMap<String, JansAttribute> attributeMap = new HashMap<String, JansAttribute>();
        for (JansAttribute attribute : attributeList) {
            attributeMap.put(StringHelper.toLowerCase((String)attribute.getName()), attribute);
        }
        return attributeMap;
    }

    protected List<JansAttribute> getAllAtributesImpl(String baseDn) {
        List attributeList = this.persistenceEntryManager.findEntries(baseDn, JansAttribute.class, null);
        return attributeList;
    }

    protected abstract BaseCacheService getCacheService();

    public abstract String getDnForAttribute(String var1);
}

