/*
 * Decompiled with CFR 0.152.
 */
package io.jans.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.jans.model.GluuBoolean;
import io.jans.model.JansAttribute;
import io.jans.model.attribute.AttributeDataType;
import io.jans.util.StringHelper;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlTransient;
import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={JansAttribute.class})
public class JansCustomAttribute
implements Serializable,
Comparable<JansCustomAttribute> {
    private static final long serialVersionUID = 1468440094325406153L;
    private String name;
    private Object[] values;
    private transient JansAttribute metadata;
    private transient boolean newAttribute = false;
    private transient boolean mandatory = false;
    private transient boolean readonly = false;
    private transient GluuBoolean[] booleanValues;
    private transient boolean usedBooleanValues = false;
    Map<String[], String> idComponentMap = new HashMap<String[], String>();

    public JansCustomAttribute() {
    }

    public JansCustomAttribute(String name, Object value) {
        this.name = name;
        this.setValue(value);
    }

    public JansCustomAttribute(String name, Object[] values) {
        this.name = name;
        this.values = values;
    }

    public JansCustomAttribute(String name, Object value, boolean newAttribute) {
        this.name = name;
        this.setValue(value);
        this.newAttribute = newAttribute;
    }

    public JansCustomAttribute(String name, Object value, boolean newAttribute, boolean mandatory) {
        this.name = name;
        this.setValue(value);
        this.newAttribute = newAttribute;
        this.mandatory = mandatory;
    }

    public JansCustomAttribute(String name, Object[] values, boolean newAttribute, boolean mandatory) {
        this.name = name;
        this.values = values;
        this.newAttribute = newAttribute;
        this.mandatory = mandatory;
    }

    public JansCustomAttribute(String name, Set<String> values) {
        this.name = name;
        this.values = values.toArray(new String[0]);
    }

    public Object getValue() {
        if (this.values == null) {
            return null;
        }
        if (this.values.length > 0) {
            return this.values[0];
        }
        return null;
    }

    public void setValue(Object value) {
        if (this.values == null) {
            this.values = new Object[0];
        }
        if (this.values.length != 1) {
            this.values = new Object[1];
        }
        this.values[0] = value;
    }

    public String getStringValue() {
        if (this.values == null) {
            return null;
        }
        if (this.values.length > 0) {
            return StringHelper.toString((Object)this.values[0]);
        }
        return null;
    }

    public GluuBoolean getBooleanValue() {
        if (this.booleanValues == null) {
            return null;
        }
        if (this.booleanValues.length > 0) {
            return this.booleanValues[0];
        }
        return null;
    }

    public void setBooleanValue(GluuBoolean value) {
        if (this.booleanValues == null) {
            this.booleanValues = new GluuBoolean[0];
        }
        if (this.booleanValues.length != 1) {
            this.booleanValues = new GluuBoolean[1];
        }
        this.booleanValues[0] = value;
    }

    public Object[] getValues() {
        if (this.metadata != null && AttributeDataType.BOOLEAN == this.metadata.getDataType() && this.usedBooleanValues) {
            this.values = this.toBooleanValuesFromGluuBooleanValues(this.booleanValues);
        }
        return this.values;
    }

    public String[] getStringValues() {
        if (this.values instanceof String[]) {
            return (String[])this.values;
        }
        if (this.values == null) {
            return null;
        }
        return StringHelper.toStringArray((Object[])this.values);
    }

    public GluuBoolean[] getBooleanValues() {
        this.usedBooleanValues = true;
        return this.booleanValues;
    }

    public void setBooleanValues(GluuBoolean[] booleanValues) {
        this.usedBooleanValues = true;
        this.booleanValues = booleanValues;
    }

    @JsonIgnore
    @XmlTransient
    @Transient
    public void setValues(String[] values) {
        this.values = values;
    }

    public void setValues(List<Object> values) {
        this.values = values.toArray(new Object[0]);
    }

    @JsonIgnore
    @XmlTransient
    @Transient
    public void setValues(Set<String> values) {
        this.values = values.toArray(new String[0]);
    }

    public boolean isNew() {
        return this.newAttribute;
    }

    public void setNew(boolean newAttribute) {
        this.newAttribute = newAttribute;
    }

    public Object getDisplayValue() {
        if (this.values == null || this.values.length == 0) {
            return "";
        }
        if (this.values.length == 1) {
            return String.valueOf(this.values[0]);
        }
        StringBuilder sb = new StringBuilder(String.valueOf(this.values[0]));
        for (int i = 1; i < this.values.length; ++i) {
            sb.append(", ").append(String.valueOf(this.values[i]));
        }
        return sb.toString();
    }

    public boolean isAdminCanAccess() {
        return this.metadata != null && this.metadata.isAdminCanAccess();
    }

    public boolean isAdminCanView() {
        return this.metadata != null && this.metadata.isAdminCanView();
    }

    public boolean isAdminCanEdit() {
        return this.metadata != null && this.metadata.isAdminCanEdit();
    }

    public boolean isUserCanAccess() {
        return this.metadata != null && this.metadata.isUserCanAccess();
    }

    public boolean isUserCanView() {
        return this.metadata != null && this.metadata.isUserCanView();
    }

    public boolean isUserCanEdit() {
        return this.metadata != null && this.metadata.isUserCanEdit();
    }

    public boolean isMultiValued() {
        return this.metadata != null && this.metadata.getOxMultiValuedAttribute() != false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JansAttribute getMetadata() {
        return this.metadata;
    }

    public void setMetadata(JansAttribute metadata) {
        this.metadata = metadata;
        if (this.metadata != null && AttributeDataType.BOOLEAN == this.metadata.getDataType()) {
            this.booleanValues = this.toBooleanValuesFromStringValues(this.values);
        }
    }

    public boolean isNewAttribute() {
        return this.newAttribute;
    }

    public void setNewAttribute(boolean newAttribute) {
        this.newAttribute = newAttribute;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JansCustomAttribute that = (JansCustomAttribute)o;
        return !(this.name == null ? that.name != null : !this.name.equalsIgnoreCase(that.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return String.format("Attribute [name=%s, values=%s, metadata=%s]", this.name, Arrays.toString(this.values), this.metadata);
    }

    @Override
    public int compareTo(JansCustomAttribute o) {
        return this.name.compareTo(o.name);
    }

    private GluuBoolean[] toBooleanValuesFromStringValues(Object[] inputValues) {
        if (inputValues == null) {
            return null;
        }
        GluuBoolean[] resultValues = new GluuBoolean[inputValues.length];
        for (int i = 0; i < inputValues.length; ++i) {
            resultValues[i] = this.toBooleanFromString(inputValues[i]);
        }
        return resultValues;
    }

    private String[] toStringValuesFromBooleanValues(GluuBoolean[] inputValues) {
        if (inputValues == null) {
            return null;
        }
        String[] resultValues = new String[inputValues.length];
        for (int i = 0; i < inputValues.length; ++i) {
            resultValues[i] = this.toStringFromBoolean(inputValues[i]);
        }
        return resultValues;
    }

    private Boolean[] toBooleanValuesFromGluuBooleanValues(GluuBoolean[] inputValues) {
        if (inputValues == null) {
            return null;
        }
        Boolean[] resultValues = new Boolean[inputValues.length];
        for (int i = 0; i < inputValues.length; ++i) {
            if (inputValues[i] == null) continue;
            resultValues[i] = inputValues[i].isBooleanValue();
        }
        return resultValues;
    }

    protected GluuBoolean toBooleanFromString(Object value) {
        if (value == null) {
            return null;
        }
        return GluuBoolean.getByValue(String.valueOf(value));
    }

    protected String toStringFromBoolean(GluuBoolean value) {
        if (value == null) {
            return null;
        }
        return value.getValue();
    }
}

