/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.logger;

import io.jans.model.types.LoggingLayoutType;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.ConfigurationUpdate;
import io.jans.service.cdi.event.LoggerUpdateEvent;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import io.jans.util.StringHelper;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.LogManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.JsonLayout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;

public abstract class LoggerService {
    private static final JsonLayout DEFAULT_JSON_PATTERN_LAYOUT = JsonLayout.createDefaultLayout();
    private static final PatternLayout DEFAULT_TEXT_PATTERN_LAYOUT = PatternLayout.newBuilder().withPattern("%d %-5p [%t] [%C{6}] (%F:%L) - %m%n").build();
    private static final int DEFAULT_INTERVAL = 15;
    private static final String OVERRIDE_JAVA_PROPERTY = "log4j2.configurationFile";
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    private Level prevLogLevel;
    private LoggingLayoutType prevLogLoggingLayout;
    private AtomicBoolean isActive;
    private boolean useExternalConfiguration = false;

    @PostConstruct
    public void create() {
        this.isActive = new AtomicBoolean(false);
    }

    public void initTimer() {
        this.initTimer(false);
    }

    public void initTimer(boolean updateNow) {
        this.isDisableConfigurationUpdate(false);
        this.log.info("Initializing Logger Update Timer");
        int delay = 15;
        int interval = 15;
        this.prevLogLevel = this.getCurrentLogLevel();
        this.prevLogLoggingLayout = this.getCurrentLoggingLayout();
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(15, 15), (Object)new LoggerUpdateEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
        if (updateNow) {
            this.updateLoggerTimerEvent(null);
        }
    }

    @Asynchronous
    public void updateLoggerTimerEvent(@Observes @Scheduled LoggerUpdateEvent loggerUpdateEvent) {
        if (this.isDisableConfigurationUpdate(true)) {
            return;
        }
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.updateLoggerConfiguration(true);
            this.prevLogLevel = this.getCurrentLogLevel();
            this.prevLogLoggingLayout = this.getCurrentLoggingLayout();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while updating newly added logger configuration", ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    @Asynchronous
    public void updateLoggerSeverity(@Observes @ConfigurationUpdate Object appConfiguration) {
        if (this.isDisableConfigurationUpdate(true)) {
            return;
        }
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.updateApplicationConfiguration();
            this.prevLogLevel = this.getCurrentLogLevel();
            this.prevLogLoggingLayout = this.getCurrentLoggingLayout();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while updating logger configuration after base configuration update", ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private boolean isDisableConfigurationUpdate(boolean silent) {
        if (!silent) {
            if (System.getProperty(OVERRIDE_JAVA_PROPERTY) != null) {
                this.log.info("Property log4j2.configurationFile is specifed. Ignoring it according to \"disableExternalLoggerConfiguration\" configuration property");
            }
            if (this.isDisableExternalLoggerConfiguration()) {
                this.log.info("External configuration is disabled with 'disableExternalLoggerConfiguration=true'");
            }
        }
        if (this.isDisableExternalLoggerConfiguration()) {
            if (System.getProperty(OVERRIDE_JAVA_PROPERTY) != null) {
                this.log.info("Property log4j2.configurationFile is cleared");
                System.clearProperty(OVERRIDE_JAVA_PROPERTY);
                this.resetLoggerConfigLocation();
            }
            return false;
        }
        if (System.getProperty(OVERRIDE_JAVA_PROPERTY) != null && !silent) {
            this.log.info("Property log4j2.configurationFile is specifed. Update configuration is turned off");
        }
        return true;
    }

    private void updateApplicationConfiguration() {
        this.log.info("Starting logging configuration update after configuration change");
        this.setDisableJdkLogger();
        boolean prevUseExternalConfiguration = this.useExternalConfiguration;
        this.useExternalConfiguration = this.setExternalLoggerConfig();
        if (this.useExternalConfiguration) {
            this.log.info("Using external logging configuration. Layout type and log level update were disabled");
            return;
        }
        if (prevUseExternalConfiguration) {
            this.log.info("Replacing logging configuration with default one. Layout type and log level update were enabled");
            this.resetLoggerConfigLocation();
        }
        this.updateLoggerConfiguration(false);
    }

    private void updateLoggerConfiguration(boolean isLoggerUpdateEvent) {
        if (this.useExternalConfiguration) {
            this.log.trace("Using external logging configuration");
        }
        if (this.checkLoggingConfig()) {
            this.log.warn("Log level is invalid in logging configuration");
            return;
        }
        Level level = this.getCurrentLogLevel();
        LoggingLayoutType loggingLayout = this.getCurrentLoggingLayout();
        String msgPattern = isLoggerUpdateEvent ? "Starting layout and loggers level periodic update. Layout: '{}', level: '{}'. Previous Layout: '{}', level: '{}'" : "Starting layout and loggers level after configuration update. Layout: '{}', level: '{}' ";
        this.log.info(msgPattern, new Object[]{loggingLayout, level, this.prevLogLoggingLayout, this.prevLogLevel});
        this.updateAppendersAndLogLevel(this.prevLogLoggingLayout, loggingLayout, this.prevLogLevel, level);
    }

    private void setDisableJdkLogger() {
        if (this.isDisableJdkLogger()) {
            this.log.info("Starting JDK loggers update");
            java.util.logging.Logger globalLogger = java.util.logging.Logger.getLogger("global");
            if (globalLogger != null && globalLogger.getLevel() != java.util.logging.Level.OFF) {
                this.log.info("Disabling JDK loggers");
                LogManager.getLogManager().reset();
                globalLogger.setLevel(java.util.logging.Level.OFF);
            }
        }
    }

    private boolean setExternalLoggerConfig() {
        String externalLoggerConfiguration = this.getExternalLoggerConfiguration();
        if (StringUtils.isEmpty((CharSequence)externalLoggerConfiguration)) {
            this.log.trace("External log configuration is not provided");
            return false;
        }
        this.log.info("External log configuration: {}", (Object)externalLoggerConfiguration);
        File log4jFile = new File(externalLoggerConfiguration);
        if (!log4jFile.exists()) {
            this.log.info("External log configuration file '{}' does not exist.", (Object)log4jFile.getAbsolutePath());
            return false;
        }
        LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
        if (loggerContext.getConfigLocation() != log4jFile.toURI()) {
            this.log.info("Starting logger context reconfigure after setting path to external configuration: '{}'", (Object)log4jFile.toURI());
            loggerContext.setConfigLocation(log4jFile.toURI());
            loggerContext.reconfigure();
        } else {
            this.log.debug("Logger context reconfigure is not required. Logconfiguration path is the same");
        }
        return true;
    }

    public void resetLoggerConfigLocation() {
        this.log.info("Reloading log4j2 configuration");
        LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
        if (loggerContext.getConfigLocation() != null) {
            loggerContext.setConfigLocation(null);
            loggerContext.reconfigure();
        }
    }

    private void updateAppendersAndLogLevel(LoggingLayoutType prevLoggingLayout, LoggingLayoutType newLoggingLayout, Level prevLevel, Level newLevel) {
        LoggerContext ctx = LoggerContext.getContext((boolean)false);
        Level rootLevel = ctx.getConfiguration().getRootLogger().getLevel();
        if (newLevel != prevLevel && newLevel != rootLevel) {
            this.log.info("Updating root level to '{}'", (Object)newLevel);
            ctx.getConfiguration().getRootLogger().setLevel(newLevel);
            ctx.updateLoggers();
        }
        if (prevLoggingLayout != newLoggingLayout || prevLevel != newLevel) {
            if (prevLoggingLayout == null) {
                this.log.info("Setting logging layout to specified in configuration '{}'", (Object)newLoggingLayout);
            } else {
                this.log.info("Updating logging layout configuration from '{}' to '{}' and loggin level from '{}' to '{}'", new Object[]{prevLoggingLayout, newLoggingLayout, prevLevel, newLevel});
            }
            this.updateLoggerConfig(newLoggingLayout, newLevel, ctx);
        }
        this.updateActiveLoggers(newLevel, ctx);
    }

    private void updateActiveLoggers(Level newLevel, LoggerContext ctx) {
        int count = 0;
        for (org.apache.logging.log4j.core.Logger logger : ctx.getLoggers()) {
            String loggerName = logger.getName();
            if (!loggerName.startsWith("io.jans") || logger.getLevel() == newLevel) continue;
            ++count;
            logger.setLevel(newLevel);
        }
        if (count > 0) {
            this.log.info("Updated '{}' loggers to level '{}'", (Object)count, (Object)newLevel.toString());
        }
    }

    private void updateLoggerConfig(LoggingLayoutType loggingLayout, Level newLevel, LoggerContext ctx) {
        int loggerConfigUpdates = 0;
        int appenderConfigUpdates = 0;
        HashMap<String, String> updates = new HashMap<String, String>();
        AbstractConfiguration config = (AbstractConfiguration)ctx.getConfiguration();
        for (Map.Entry loggerConfigEntry : config.getLoggers().entrySet()) {
            LoggerConfig loggerConfig = (LoggerConfig)loggerConfigEntry.getValue();
            this.log.debug("Analyzing log configuration '{}'", (Object)loggerConfig.getName());
            if (!loggerConfig.getLevel().equals((Object)newLevel)) {
                loggerConfig.setLevel(newLevel);
                this.log.debug("Updating log level in configuration '{}' to '{}'", (Object)loggerConfig.getName(), (Object)newLevel);
                ++loggerConfigUpdates;
            }
            for (Map.Entry appenderEntry : loggerConfig.getAppenders().entrySet()) {
                Appender appender = (Appender)appenderEntry.getValue();
                this.log.debug("Analyzing appender '{}'", (Object)appender.getName());
                Layout layout = appender.getLayout();
                if (loggingLayout == LoggingLayoutType.TEXT) {
                    layout = DEFAULT_TEXT_PATTERN_LAYOUT;
                } else if (loggingLayout == LoggingLayoutType.JSON) {
                    layout = DEFAULT_JSON_PATTERN_LAYOUT;
                }
                if (appender instanceof RollingFileAppender) {
                    RollingFileAppender rollingFile = (RollingFileAppender)appender;
                    if (rollingFile.getLayout().getClass().isAssignableFrom(layout.getClass())) {
                        this.log.debug("Skipping appender update '{}'", (Object)appender.getName());
                        continue;
                    }
                    RollingFileAppender newFileAppender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setLayout(layout)).withStrategy(((RollingFileManager)rollingFile.getManager()).getRolloverStrategy()).withPolicy(rollingFile.getTriggeringPolicy()).withFileName(rollingFile.getFileName()).withFilePattern(rollingFile.getFilePattern()).setName(rollingFile.getName())).build();
                    newFileAppender.start();
                    appender.stop();
                    loggerConfig.removeAppender((String)appenderEntry.getKey());
                    loggerConfig.addAppender((Appender)newFileAppender, newLevel, null);
                    updates.put(appender.getName(), layout.getClass().getName());
                    ++appenderConfigUpdates;
                    continue;
                }
                if (!(appender instanceof ConsoleAppender)) continue;
                ConsoleAppender consoleAppender = (ConsoleAppender)appender;
                if (consoleAppender.getLayout().getClass().isAssignableFrom(layout.getClass())) {
                    this.log.debug("Skipping appender update '{}'", (Object)appender.getName());
                    continue;
                }
                ConsoleAppender newConsoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setLayout(layout)).setTarget(consoleAppender.getTarget()).setName(consoleAppender.getName())).build();
                newConsoleAppender.start();
                appender.stop();
                loggerConfig.removeAppender((String)appenderEntry.getKey());
                loggerConfig.addAppender((Appender)newConsoleAppender, newLevel, null);
                updates.put(appender.getName(), layout.getClass().getName());
                ++appenderConfigUpdates;
            }
        }
        if (loggerConfigUpdates > 0 || appenderConfigUpdates > 0) {
            this.log.trace("Trigger loggers update after '{}' updates", (Object)(loggerConfigUpdates + appenderConfigUpdates));
            ctx.updateLoggers();
            for (Map.Entry entry : updates.entrySet()) {
                this.log.debug("Updated appender '{}'. New layout: '{}'", entry.getKey(), entry.getValue());
            }
        }
    }

    private boolean checkLoggingConfig() {
        return StringHelper.isEmpty((String)this.getLoggingLevel()) || StringUtils.isEmpty((CharSequence)this.getLoggingLayout()) || StringHelper.equalsIgnoreCase((String)"DEFAULT", (String)this.getLoggingLevel());
    }

    private Level getCurrentLogLevel() {
        if (this.checkLoggingConfig()) {
            return Level.INFO;
        }
        String loggingLevel = this.getLoggingLevel();
        Level level = Level.toLevel((String)loggingLevel, (Level)Level.INFO);
        return level;
    }

    private LoggingLayoutType getCurrentLoggingLayout() {
        if (this.checkLoggingConfig()) {
            return LoggingLayoutType.TEXT;
        }
        String loggingLayout = this.getLoggingLayout();
        LoggingLayoutType loggingLayoutType = LoggingLayoutType.getByValue((String)loggingLayout.toUpperCase());
        if (loggingLayoutType == null) {
            return LoggingLayoutType.TEXT;
        }
        return loggingLayoutType;
    }

    public abstract boolean isDisableJdkLogger();

    public abstract boolean isDisableExternalLoggerConfiguration();

    public abstract String getLoggingLevel();

    public abstract String getLoggingLayout();

    public abstract String getExternalLoggerConfiguration();
}

