/*
 * Decompiled with CFR 0.152.
 */
package io.jans.model;

import io.jans.model.GluuAttributeUsageType;
import io.jans.model.GluuStatus;
import io.jans.model.GluuUserRole;
import io.jans.model.attribute.AttributeDataType;
import io.jans.model.attribute.AttributeValidation;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.JsonObject;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.model.base.Entry;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.Arrays;

@DataEntry(sortBy={"displayName"})
@ObjectClass(value="jansAttr")
public class JansAttribute
extends Entry
implements Serializable {
    private static final long serialVersionUID = 4817004894646725606L;
    private transient boolean selected;
    @AttributeName(ignoreDuringUpdate=true)
    private String inum;
    @AttributeName(name="jansSourceAttr")
    private String sourceAttribute;
    @AttributeName(name="jansNameIdTyp")
    private String nameIdType;
    @NotNull
    @Pattern(regexp="^[a-zA-Z0-9_]+$", message="Name should contain alphabetical and numeric characters only")
    @Size(min=1, max=30, message="Length of the Name should be between 1 and 30")
    @AttributeName(name="jansAttrName")
    private @NotNull @Pattern(regexp="^[a-zA-Z0-9_]+$", message="Name should contain alphabetical and numeric characters only") @Size(min=1, max=30, message="Length of the Name should be between 1 and 30") String name;
    @NotNull
    @Size(min=0, max=60, message="Length of the Display Name should not exceed 60")
    @AttributeName
    private @NotNull @Size(min=0, max=60, message="Length of the Display Name should not exceed 60") String displayName;
    @NotNull
    @Size(min=0, max=4000, message="Length of the Description should not exceed 4000")
    @AttributeName
    private @NotNull @Size(min=0, max=4000, message="Length of the Description should not exceed 4000") String description;
    @AttributeName(name="jansAttrOrigin")
    private String origin;
    @NotNull
    @AttributeName(name="jansAttrTyp")
    private AttributeDataType dataType;
    @NotNull
    @AttributeName(name="jansAttrEditTyp")
    private GluuUserRole[] editType;
    @NotNull
    @AttributeName(name="jansAttrViewTyp")
    private GluuUserRole[] viewType;
    @AttributeName(name="jansAttrUsgTyp")
    private GluuAttributeUsageType[] usageType;
    @AttributeName(name="jansClaimName")
    private String claimName;
    @AttributeName(name="seeAlso")
    private String seeAlso;
    @AttributeName(name="jansStatus")
    private GluuStatus status;
    @AttributeName(name="jansSAML1URI")
    private String saml1Uri;
    @AttributeName(name="jansSAML2URI")
    private String saml2Uri;
    @AttributeName(ignoreDuringUpdate=true)
    private String urn;
    @AttributeName(name="jansScimCustomAttr")
    private Boolean scimCustomAttr;
    @AttributeName(name="jansMultivaluedAttr")
    private Boolean oxMultiValuedAttribute;
    @AttributeName(name="jansHideOnDiscovery")
    private Boolean jansHideOnDiscovery;
    @Transient
    private boolean custom;
    @JsonObject
    @AttributeName(name="jansValidation")
    private AttributeValidation attributeValidation;
    @AttributeName(name="jansTooltip")
    private String tooltip;

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getInum() {
        return this.inum;
    }

    public void setInum(String inum) {
        this.inum = inum;
    }

    public String getSourceAttribute() {
        return this.sourceAttribute;
    }

    public void setSourceAttribute(String sourceAttribute) {
        this.sourceAttribute = sourceAttribute;
    }

    public String getNameIdType() {
        return this.nameIdType;
    }

    public void setNameIdType(String nameIdType) {
        this.nameIdType = nameIdType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public AttributeDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(AttributeDataType dataType) {
        this.dataType = dataType;
    }

    public GluuUserRole[] getEditType() {
        return this.editType;
    }

    public void setEditType(GluuUserRole[] editType) {
        this.editType = editType;
    }

    public GluuUserRole[] getViewType() {
        return this.viewType;
    }

    public void setViewType(GluuUserRole[] viewType) {
        this.viewType = viewType;
    }

    public GluuAttributeUsageType[] getUsageType() {
        return this.usageType;
    }

    public void setUsageType(GluuAttributeUsageType[] usageType) {
        this.usageType = usageType;
    }

    public String getClaimName() {
        return this.claimName;
    }

    public void setClaimName(String claimName) {
        this.claimName = claimName;
    }

    public String getSeeAlso() {
        return this.seeAlso;
    }

    public void setSeeAlso(String seeAlso) {
        this.seeAlso = seeAlso;
    }

    public GluuStatus getStatus() {
        return this.status;
    }

    public void setStatus(GluuStatus status) {
        this.status = status;
    }

    public String getSaml1Uri() {
        return this.saml1Uri;
    }

    public void setSaml1Uri(String saml1Uri) {
        this.saml1Uri = saml1Uri;
    }

    public String getSaml2Uri() {
        return this.saml2Uri;
    }

    public void setSaml2Uri(String saml2Uri) {
        this.saml2Uri = saml2Uri;
    }

    public String getUrn() {
        return this.urn;
    }

    public void setUrn(String urn) {
        this.urn = urn;
    }

    public Boolean getScimCustomAttr() {
        return this.scimCustomAttr;
    }

    public void setScimCustomAttr(Boolean scimCustomAttr) {
        this.scimCustomAttr = scimCustomAttr;
    }

    public Boolean getOxMultiValuedAttribute() {
        return this.oxMultiValuedAttribute == null ? false : this.oxMultiValuedAttribute;
    }

    public void setOxMultiValuedAttribute(Boolean oxMultiValuedAttribute) {
        this.oxMultiValuedAttribute = oxMultiValuedAttribute;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom(boolean custom) {
        this.custom = custom;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public boolean allowEditBy(GluuUserRole role) {
        return GluuUserRole.containsRole(this.editType, role);
    }

    public boolean allowViewBy(GluuUserRole role) {
        return GluuUserRole.containsRole(this.viewType, role);
    }

    public boolean isAdminCanAccess() {
        return this.isAdminCanView() | this.isAdminCanEdit();
    }

    public boolean isAdminCanView() {
        return this.allowViewBy(GluuUserRole.ADMIN);
    }

    public boolean isAdminCanEdit() {
        return this.allowEditBy(GluuUserRole.ADMIN);
    }

    public boolean isUserCanAccess() {
        return this.isUserCanView() | this.isUserCanEdit();
    }

    public boolean isUserCanView() {
        return this.allowViewBy(GluuUserRole.USER);
    }

    public boolean isWhitePagesCanView() {
        return this.allowViewBy(GluuUserRole.WHITEPAGES);
    }

    public boolean isUserCanEdit() {
        return this.allowEditBy(GluuUserRole.USER);
    }

    public AttributeValidation getAttributeValidation() {
        return this.attributeValidation;
    }

    public void setAttributeValidation(AttributeValidation attributeValidation) {
        this.attributeValidation = attributeValidation;
    }

    public Boolean getJansHideOnDiscovery() {
        return this.jansHideOnDiscovery;
    }

    public void setJansHideOnDiscovery(Boolean jansHideOnDiscovery) {
        this.jansHideOnDiscovery = jansHideOnDiscovery;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.custom ? 1231 : 1237);
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + Arrays.hashCode((Object[])this.editType);
        result = 31 * result + (this.tooltip == null ? 0 : this.tooltip.hashCode());
        result = 31 * result + (this.inum == null ? 0 : this.inum.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nameIdType == null ? 0 : this.nameIdType.hashCode());
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + (this.claimName == null ? 0 : this.claimName.hashCode());
        result = 31 * result + (this.oxMultiValuedAttribute == null ? 0 : this.oxMultiValuedAttribute.hashCode());
        result = 31 * result + (this.scimCustomAttr == null ? 0 : this.scimCustomAttr.hashCode());
        result = 31 * result + (this.saml1Uri == null ? 0 : this.saml1Uri.hashCode());
        result = 31 * result + (this.saml2Uri == null ? 0 : this.saml2Uri.hashCode());
        result = 31 * result + (this.seeAlso == null ? 0 : this.seeAlso.hashCode());
        result = 31 * result + (this.sourceAttribute == null ? 0 : this.sourceAttribute.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.urn == null ? 0 : this.urn.hashCode());
        result = 31 * result + Arrays.hashCode((Object[])this.usageType);
        result = 31 * result + Arrays.hashCode((Object[])this.viewType);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JansAttribute)) {
            return false;
        }
        JansAttribute other = (JansAttribute)obj;
        if (this.inum == null ? other.inum != null : !this.inum.equals(other.inum)) {
            return false;
        }
        if (this.custom != other.custom) {
            return false;
        }
        if (this.dataType != other.dataType) {
            return false;
        }
        return !(this.description == null ? other.description != null : !this.description.equals(other.description));
    }
}

