/*
 * Decompiled with CFR 0.152.
 */
package io.jans.model.token;

import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.model.base.BaseEntry;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@DataEntry(sortBy={"jansNum"})
@ObjectClass(value="jansStatusIdxPool")
public class StatusIndexPool
extends BaseEntry {
    private static final long serialVersionUID = -2122431771066187529L;
    public static final String JANS_NUM_ATTRIBUTE_NAME = "jansNum";
    @AttributeName(ignoreDuringUpdate=true, name="jansNum")
    private Integer id;
    @AttributeName(ignoreDuringUpdate=true, name="jansNodeId")
    private Integer nodeId;
    @AttributeName(name="dat")
    private String data;
    @AttributeName(name="jansLastUpd")
    private Date lastUpdate;
    @AttributeName(name="exp")
    private Date expirationDate;
    @AttributeName(name="lockKey")
    private String lockKey;
    @Transient
    private transient Integer startIndex;
    @Transient
    private transient Integer endIndex;
    @Transient
    private transient AtomicInteger currentIndex = new AtomicInteger(-1);

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(Integer nodeId) {
        this.nodeId = nodeId;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getLockKey() {
        return this.lockKey;
    }

    public void setLockKey(String lockKey) {
        this.lockKey = lockKey;
    }

    public List<Integer> enumerateAllIndexes() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = this.getStartIndex().intValue(); i <= this.getEndIndex(); ++i) {
            indexes.add(i);
        }
        return indexes;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
        this.currentIndex.set(startIndex);
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(Integer endIndex) {
        this.endIndex = endIndex;
    }

    public int nextIndex() {
        if (this.expirationDate == null || this.expirationDate.before(new Date())) {
            return -1;
        }
        int nextIndex = this.currentIndex.getAndIncrement();
        if (nextIndex > this.endIndex) {
            return -1;
        }
        return nextIndex;
    }
}

