/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.external.context;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalScriptContext {
    private static final Logger log = LoggerFactory.getLogger(ExternalScriptContext.class);
    private final Map<String, Object> contextVariables = new HashMap<String, Object>();
    protected HttpServletRequest httpRequest;
    protected final HttpServletResponse httpResponse;

    public ExternalScriptContext(HttpServletRequest httpRequest) {
        this(httpRequest, null);
    }

    public ExternalScriptContext(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        ExternalContext extCtx;
        FacesContext facesContext;
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        if (this.httpRequest == null && (facesContext = FacesContext.getCurrentInstance()) != null && (extCtx = facesContext.getExternalContext()) != null) {
            this.httpRequest = (HttpServletRequest)extCtx.getRequest();
        }
    }

    public Logger getLog() {
        return log;
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpServletResponse getHttpResponse() {
        return this.httpResponse;
    }

    public String getIpAddress() {
        return this.httpRequest != null ? this.httpRequest.getRemoteAddr() : "";
    }

    public Map<String, Object> getContextVariables() {
        return this.contextVariables;
    }
}

