/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.net;

import io.jans.model.net.HttpServiceResponse;
import io.jans.util.StringHelper;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;

public abstract class BaseHttpService
implements Serializable {
    private static final long serialVersionUID = -2398422090669045605L;
    @Inject
    private Logger log;
    private Base64 base64;
    private PoolingHttpClientConnectionManager connectionManager;

    @PostConstruct
    public void init() {
        this.connectionManager = new PoolingHttpClientConnectionManager();
        this.connectionManager.setMaxTotal(200);
        this.connectionManager.setDefaultMaxPerRoute(50);
        this.base64 = new Base64();
    }

    public CloseableHttpClient getHttpsClientTrustAll() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        this.log.trace("Connection manager stats: {}", (Object)this.connectionManager.getTotalStats());
        TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
        SSLConnectionSocketFactory sslConSocFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConSocFactory).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
    }

    public CloseableHttpClient getHttpsClient() {
        return this.getHttpsClient(RequestConfig.custom().build());
    }

    public CloseableHttpClient getHttpsClient(RequestConfig requestConfig) {
        this.log.trace("Connection manager stats: {}", (Object)this.connectionManager.getTotalStats());
        return HttpClients.custom().setDefaultRequestConfig(RequestConfig.copy((RequestConfig)requestConfig).setCookieSpec("standard").build()).setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
    }

    public CloseableHttpClient getHttpsClient(HttpRoutePlanner routerPlanner) {
        this.log.trace("Connection manager stats: {}", (Object)this.connectionManager.getTotalStats());
        return this.getHttpsClient(RequestConfig.custom().build(), routerPlanner);
    }

    public CloseableHttpClient getHttpsClient(RequestConfig requestConfig, HttpRoutePlanner routerPlanner) {
        this.log.trace("Connection manager stats: {}", (Object)this.connectionManager.getTotalStats());
        return HttpClients.custom().setDefaultRequestConfig(RequestConfig.copy((RequestConfig)requestConfig).setCookieSpec("standard").build()).setConnectionManager((HttpClientConnectionManager)this.connectionManager).setRoutePlanner(routerPlanner).build();
    }

    public CloseableHttpClient getHttpsClient(String trustStoreType, String trustStorePath, String trustStorePassword) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        this.log.trace("Connection manager stats: {}", (Object)this.connectionManager.getTotalStats());
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(new File(trustStorePath), trustStorePassword.toCharArray()).build();
        SSLConnectionSocketFactory sslConSocFactory = new SSLConnectionSocketFactory(sslContext);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConSocFactory).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
    }

    public CloseableHttpClient getHttpsClient(String trustStoreType, String trustStorePath, String trustStorePassword, String keyStoreType, String keyStorePath, String keyStorePassword) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException {
        this.log.trace("Connection manager stats: {}", (Object)this.connectionManager.getTotalStats());
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(new File(trustStorePath), trustStorePassword.toCharArray()).loadKeyMaterial(new File(keyStorePath), keyStorePassword.toCharArray(), keyStorePassword.toCharArray()).build();
        SSLConnectionSocketFactory sslConSocFactory = new SSLConnectionSocketFactory(sslContext);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConSocFactory).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
    }

    public HttpServiceResponse executePost(HttpClient httpClient, String uri, String authData, Map<String, String> headers, String postData, ContentType contentType, String authType) {
        HttpPost httpPost = new HttpPost(uri);
        authType = StringHelper.isEmpty((String)authType) ? "Basic " : (String)authType + " ";
        if (StringHelper.isNotEmpty((String)authData)) {
            httpPost.setHeader("Authorization", (String)authType + authData);
        }
        if (headers != null) {
            for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
                httpPost.setHeader(headerEntry.getKey(), headerEntry.getValue());
            }
        }
        StringEntity stringEntity = new StringEntity(postData, contentType);
        httpPost.setEntity((HttpEntity)stringEntity);
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            return new HttpServiceResponse((HttpRequestBase)httpPost, httpResponse);
        }
        catch (IOException ex) {
            this.log.error("Failed to execute post request", (Throwable)ex);
            return null;
        }
    }

    public HttpServiceResponse executePost(HttpClient httpClient, String uri, String authData, Map<String, String> headers, String postData) {
        return this.executePost(httpClient, uri, authData, headers, postData, null, null);
    }

    public HttpServiceResponse executePost(HttpClient httpClient, String uri, String authData, String postData, ContentType contentType) {
        return this.executePost(httpClient, uri, authData, null, postData, contentType, null);
    }

    public HttpServiceResponse executePost(String uri, String authData, Map<String, String> headers, String postData, ContentType contentType, String authType) {
        return this.executePost((HttpClient)this.getHttpsClient(), uri, authData, null, postData, contentType, authType);
    }

    public String encodeBase64(String value) {
        try {
            return new String(this.base64.encode(value.getBytes("UTF-8")), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            this.log.error("Failed to convert '{}' to base64", (Object)value, (Object)ex);
            return null;
        }
    }

    public String encodeUrl(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            this.log.error("Failed to encode url '{}'", (Object)value, (Object)ex);
            return null;
        }
    }

    public HttpServiceResponse executeGet(HttpClient httpClient, String requestUri, Map<String, String> headers) {
        HttpGet httpGet = new HttpGet(requestUri);
        if (headers != null) {
            for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
                httpGet.setHeader(headerEntry.getKey(), headerEntry.getValue());
            }
        }
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            return new HttpServiceResponse((HttpRequestBase)httpGet, httpResponse);
        }
        catch (IOException ex) {
            this.log.error("Failed to execute get request", (Throwable)ex);
            return null;
        }
    }

    public HttpServiceResponse executeGet(HttpClient httpClient, String requestUri) throws ClientProtocolException, IOException {
        return this.executeGet(httpClient, requestUri, null);
    }

    public byte[] getResponseContent(HttpResponse httpResponse) throws IOException {
        if (httpResponse == null || !this.isResponseStastusCodeOk(httpResponse)) {
            return null;
        }
        HttpEntity entity = httpResponse.getEntity();
        byte[] responseBytes = new byte[]{};
        if (entity != null) {
            responseBytes = EntityUtils.toByteArray((HttpEntity)entity);
        }
        if (entity != null) {
            EntityUtils.consume((HttpEntity)entity);
        }
        return responseBytes;
    }

    public void consume(HttpResponse httpResponse) throws IOException {
        if (httpResponse == null || !this.isResponseStastusCodeOk(httpResponse)) {
            return;
        }
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            EntityUtils.consume((HttpEntity)entity);
        }
    }

    public String convertEntityToString(byte[] responseBytes) {
        if (responseBytes == null) {
            return null;
        }
        return new String(responseBytes);
    }

    public String convertEntityToString(byte[] responseBytes, Charset charset) {
        if (responseBytes == null) {
            return null;
        }
        return new String(responseBytes, charset);
    }

    public String convertEntityToString(byte[] responseBytes, String charsetName) throws UnsupportedEncodingException {
        if (responseBytes == null) {
            return null;
        }
        return new String(responseBytes, charsetName);
    }

    public boolean isResponseStastusCodeOk(HttpResponse httpResponse) {
        int responseStastusCode = httpResponse.getStatusLine().getStatusCode();
        return responseStastusCode == 200 || responseStastusCode == 201 || responseStastusCode == 202 || responseStastusCode == 203 || responseStastusCode == 204 || responseStastusCode == 205 || responseStastusCode == 206 || responseStastusCode == 207;
    }

    public boolean isResponseStatusCodeOk(HttpResponse httpResponse) {
        return this.isResponseStastusCodeOk(httpResponse);
    }

    public boolean isContentTypeXml(HttpResponse httpResponse) {
        Header contentType = httpResponse.getEntity().getContentType();
        if (contentType == null) {
            return false;
        }
        String contentTypeValue = contentType.getValue();
        return StringHelper.equals((String)contentTypeValue, (String)ContentType.APPLICATION_XML.getMimeType()) || StringHelper.equals((String)contentTypeValue, (String)ContentType.TEXT_XML.getMimeType());
    }

    public String constructServerUrl(HttpServletRequest request) {
        int serverPort = request.getServerPort();
        String redirectUrl = serverPort == 80 || serverPort == 443 ? String.format("%s://%s%s", request.getScheme(), request.getServerName(), request.getContextPath()) : String.format("%s://%s:%s%s", request.getScheme(), request.getServerName(), request.getServerPort(), request.getContextPath());
        return redirectUrl.toLowerCase();
    }

    public HttpRoutePlanner buildDefaultRoutePlanner(String hostname, int port, String scheme) {
        HttpHost proxyHost = new HttpHost(hostname, port, scheme);
        return new DefaultProxyRoutePlanner(proxyHost);
    }

    public HttpRoutePlanner buildDefaultRoutePlanner(String proxy) {
        return this.buildDefaultRoutePlanner(proxy, -1, null);
    }
}

