/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.timer;

import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.weld.context.bound.BoundRequestContext;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.slf4j.Logger;

@Dependent
public class RequestJobListener
implements JobListener {
    @Inject
    private Logger log;
    @Inject
    private BoundRequestContext requestContext;
    protected static final String REQUEST_DATA_STORE_KEY = RequestJobListener.class.getName() + "_REQUEST_DATA_STORE_KEY";

    public String getName() {
        return this.getClass().getName();
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        this.startRequest(context);
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        this.endRequest(context);
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        this.endRequest(context);
    }

    protected void startRequest(JobExecutionContext context) {
        Map requestDataStore = Collections.synchronizedMap(new HashMap());
        context.put((Object)REQUEST_DATA_STORE_KEY, requestDataStore);
        this.requestContext.associate(requestDataStore);
        this.requestContext.activate();
        this.log.debug("Bound request started");
    }

    protected void endRequest(JobExecutionContext context) {
        try {
            this.requestContext.invalidate();
            this.requestContext.deactivate();
        }
        finally {
            this.requestContext.dissociate((Object)((Map)context.get((Object)REQUEST_DATA_STORE_KEY)));
        }
        this.log.debug("Bound request ended");
    }
}

