/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.timer;

import io.jans.service.timer.event.TimerEvent;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;

@Dependent
public class TimerJob
implements Job {
    public static final String KEY_TIMER_EVENT = TimerEvent.class.getName();
    public static final String TIMER_JOB_GROUP = "TimerJobGroup";
    @Inject
    private Logger log;
    @Inject
    private BeanManager beanManager;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            TimerEvent timerEvent = (TimerEvent)context.getJobDetail().getJobDataMap().get((Object)KEY_TIMER_EVENT);
            if (timerEvent == null) {
                return;
            }
            this.log.debug("Fire timer event [{}] with qualifiers {} from instance {}", new Object[]{timerEvent.getTargetEvent().getClass().getName(), timerEvent.getQualifiers(), System.identityHashCode(this)});
            this.beanManager.fireEvent(timerEvent.getTargetEvent(), timerEvent.getQualifiers());
        }
        catch (Exception ex) {
            throw new JobExecutionException((Throwable)ex);
        }
    }
}

