/*
 * Decompiled with CFR 0.152.
 */
package io.jans.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.persistence.Transient;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;

@XmlRootElement
@JsonIgnoreProperties(value={"sourceFilePath", "thumbFilePath", "storeTemporary", "logo", "landscape"})
public class GluuImage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String uuid;
    private String creator;
    private String sourceName;
    private Date creationDate;
    private String sourceContentType;
    private String sourceFilePath;
    private long size;
    private int width;
    private int height;
    private String thumbContentType;
    private int thumbWidth;
    private int thumbHeight;
    private byte[] data;
    private byte[] thumbData;
    private String thumbFilePath;
    private boolean storeTemporary;
    private boolean logo;

    @Transient
    @XmlTransient
    public boolean isLandscape() {
        return this.width > this.height;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getSourceFilePath() {
        return this.sourceFilePath;
    }

    public void setSourceFilePath(String sourceFilePath) {
        this.sourceFilePath = sourceFilePath;
    }

    public Date getCreationDate() {
        return this.creationDate != null ? new Date(this.creationDate.getTime()) : null;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate != null ? new Date(creationDate.getTime()) : null;
    }

    public String getSourceContentType() {
        return this.sourceContentType;
    }

    public void setSourceContentType(String sourceContentType) {
        this.sourceContentType = sourceContentType;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getThumbFilePath() {
        return this.thumbFilePath;
    }

    public void setThumbFilePath(String thumbFilePath) {
        this.thumbFilePath = thumbFilePath;
    }

    public String getThumbContentType() {
        return this.thumbContentType;
    }

    public void setThumbContentType(String thumbContentType) {
        this.thumbContentType = thumbContentType;
    }

    public int getThumbWidth() {
        return this.thumbWidth;
    }

    public void setThumbWidth(int thumbWidth) {
        this.thumbWidth = thumbWidth;
    }

    public int getThumbHeight() {
        return this.thumbHeight;
    }

    public void setThumbHeight(int thumbHeight) {
        this.thumbHeight = thumbHeight;
    }

    public void setStoreTemporary(boolean storeTemporary) {
        this.storeTemporary = storeTemporary;
    }

    @Transient
    @XmlTransient
    public boolean isStoreTemporary() {
        return this.storeTemporary;
    }

    public void setLogo(boolean logo) {
        this.logo = logo;
    }

    @Transient
    @XmlTransient
    public boolean isLogo() {
        return this.logo;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Transient
    @XmlTransient
    public byte[] getData() {
        return this.data;
    }

    public byte[] getThumbData() {
        return this.thumbData;
    }

    public void setThumbData(byte[] thumbData) {
        this.thumbData = thumbData;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GluuImage other = (GluuImage)obj;
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GluuImage [uuid=").append(this.uuid).append(", creator=").append(this.creator).append(", sourceName=").append(this.sourceName).append(", creationDate=").append(this.creationDate).append(", sourceContentType=").append(this.sourceContentType).append(", sourceFilePath=").append(this.sourceFilePath).append(", size=").append(this.size).append(", width=").append(this.width).append(", height=").append(this.height).append(", thumbContentType=").append(this.thumbContentType).append(", thumbWidth=").append(this.thumbWidth).append(", thumbHeight=").append(this.thumbHeight).append(", data=").append(Arrays.toString(this.data)).append(", thumbData=").append(Arrays.toString(this.thumbData)).append(", thumbFilePath=").append(this.thumbFilePath).append(", storeTemporary=").append(this.storeTemporary).append(", logo=").append(this.logo).append("]");
        return builder.toString();
    }
}

