/*
 * Decompiled with CFR 0.152.
 */
package io.jans.util.image;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public final class ImageTransformationUtility {
    private ImageTransformationUtility() {
    }

    public static BufferedImage scaleImage(BufferedImage img, int maxWidth, int maxHeight) {
        return ImageTransformationUtility.scaleImage(img, maxWidth, maxHeight, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
    }

    public static BufferedImage scaleImage(BufferedImage img, int maxWidth, int maxHeight, Object hint, boolean higherQuality) {
        int currentheight;
        int currentWidth;
        boolean downScale;
        int targetHeight;
        double hRatio;
        BufferedImage ret = img;
        if (img.getWidth() <= maxWidth && img.getHeight() <= maxHeight) {
            return ret;
        }
        int type = img.getTransparency() == 1 ? 1 : 2;
        int targetWidth = img.getWidth();
        double wRatio = (double)targetWidth / (double)maxWidth;
        if (wRatio > (hRatio = (double)(targetHeight = img.getHeight()) / (double)maxHeight)) {
            targetWidth = maxWidth;
            targetHeight = (int)((double)targetHeight / wRatio);
        } else {
            targetWidth = (int)((double)targetWidth / hRatio);
            targetHeight = maxHeight;
        }
        boolean bl = downScale = img.getWidth() > maxWidth || img.getHeight() > maxHeight;
        if (higherQuality) {
            currentWidth = img.getWidth();
            currentheight = img.getHeight();
        } else {
            currentWidth = targetWidth;
            currentheight = targetHeight;
        }
        do {
            if (downScale) {
                if (higherQuality && currentWidth > targetWidth && (currentWidth /= 2) < targetWidth) {
                    currentWidth = targetWidth;
                }
                if (higherQuality && currentheight > targetHeight && (currentheight /= 2) < targetHeight) {
                    currentheight = targetHeight;
                }
            } else {
                currentWidth = targetWidth;
                currentheight = targetWidth;
            }
            BufferedImage tmp = new BufferedImage(currentWidth, currentheight, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, currentWidth, currentheight, null);
            g2.dispose();
            ret = tmp;
        } while (currentWidth != targetWidth || currentheight != targetHeight);
        return ret;
    }
}

