/*
 * Decompiled with CFR 0.152.
 */
package io.jans.util.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class ReverseLineReader {
    private static final int BUFFER_SIZE = 8192;
    private final File file;
    private final String encoding;
    private RandomAccessFile raf;
    private FileChannel channel;
    private long filePos;
    private ByteBuffer buf;
    private long bufPos;
    private ByteArrayOutputStream baos;
    private boolean initialized = false;

    public ReverseLineReader(File file, String encoding) {
        this.file = file;
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        ReverseLineReader reverseLineReader = this;
        synchronized (reverseLineReader) {
            if (this.raf == null) {
                this.raf = new RandomAccessFile(this.file, "r");
                this.channel = this.raf.getChannel();
                this.filePos = this.raf.length();
                this.bufPos = 0L;
                this.baos = new ByteArrayOutputStream();
                this.initialized = true;
            }
        }
    }

    public String readLastLine() throws IOException {
        if (!this.initialized) {
            this.init();
        }
        block0: while (true) {
            if (this.bufPos < 0L) {
                if (this.filePos == 0L) {
                    if (this.baos == null) {
                        return null;
                    }
                    String line = this.buildResultString();
                    this.baos = null;
                    return line;
                }
                long start = Math.max(this.filePos - 8192L, 0L);
                long end = this.filePos;
                long len = end - start;
                this.buf = this.channel.map(FileChannel.MapMode.READ_ONLY, start, len);
                this.bufPos = len;
            }
            while (true) {
                if (this.bufPos-- <= 0L) continue block0;
                byte c = this.buf.get((int)this.bufPos);
                --this.filePos;
                if (c == 13 || c == 10) {
                    if (this.baos.size() == 0) continue;
                    return this.buildResultString();
                }
                this.baos.write(c);
            }
            break;
        }
    }

    public List<String> readLastLines(int countLines) throws IOException {
        String line;
        ArrayList<String> lastLines = new ArrayList<String>(countLines);
        for (int i = 0; i < countLines && (line = this.readLastLine()) != null; ++i) {
            lastLines.add(0, line);
        }
        return lastLines;
    }

    private String buildResultString() throws UnsupportedEncodingException {
        if (this.baos.size() == 0) {
            return "";
        }
        byte[] bytes = this.baos.toByteArray();
        this.swapBytes(bytes);
        this.baos.reset();
        return new String(bytes, this.encoding);
    }

    public void swapBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length / 2; ++i) {
            byte t = bytes[i];
            bytes[i] = bytes[bytes.length - i - 1];
            bytes[bytes.length - i - 1] = t;
        }
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.raf != null) {
            this.raf.close();
        }
    }
}

