/*
 * Decompiled with CFR 0.152.
 */
package io.jans.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jans.model.SmtpConnectProtectionType;
import jakarta.persistence.Transient;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SmtpConfiguration
implements Serializable {
    private static final long serialVersionUID = -5675038049444038755L;
    @JsonProperty(value="host")
    private String host = null;
    @JsonProperty(value="port")
    private int port = 0;
    @JsonProperty(value="connect_protection")
    private SmtpConnectProtectionType connectProtection = null;
    @JsonProperty(value="trust_host")
    private boolean serverTrust = false;
    @JsonProperty(value="from_name")
    private String fromName = null;
    @JsonProperty(value="from_email_address")
    private String fromEmailAddress = null;
    @JsonProperty(value="requires_authentication")
    private boolean requiresAuthentication = false;
    @JsonProperty(value="smtp_authentication_account_username")
    private String smtpAuthenticationAccountUsername = null;
    @JsonProperty(value="smtp_authentication_account_password")
    private String smtpAuthenticationAccountPassword = null;
    @Transient
    @JsonIgnore
    private String smtpAuthenticationAccountPasswordDecrypted = null;
    @JsonProperty(value="key_store")
    private String keyStore = null;
    @JsonProperty(value="key_store_password")
    private String keyStorePassword = null;
    @Transient
    @JsonIgnore
    private String keyStorePasswordDecrypted = null;
    @JsonProperty(value="key_store_alias")
    private String keyStoreAlias = null;
    @JsonProperty(value="signing_algorithm")
    private String signingAlgorithm = null;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public SmtpConnectProtectionType getConnectProtection() {
        return this.connectProtection;
    }

    public void setConnectProtection(SmtpConnectProtectionType connectProtection) {
        this.connectProtection = connectProtection;
    }

    public boolean isServerTrust() {
        return this.serverTrust;
    }

    public void setServerTrust(boolean serverTrust) {
        this.serverTrust = serverTrust;
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public String getFromEmailAddress() {
        return this.fromEmailAddress;
    }

    public void setFromEmailAddress(String fromEmailAddress) {
        this.fromEmailAddress = fromEmailAddress;
    }

    public boolean isRequiresAuthentication() {
        return this.requiresAuthentication;
    }

    public void setRequiresAuthentication(boolean requiresAuthentication) {
        this.requiresAuthentication = requiresAuthentication;
    }

    public boolean isValid() {
        return this.getHost() != null && this.getPort() != 0 && (!this.isRequiresAuthentication() || this.getSmtpAuthenticationAccountUsername() != null && this.getSmtpAuthenticationAccountPassword() != null);
    }

    public String getSmtpAuthenticationAccountUsername() {
        return this.smtpAuthenticationAccountUsername;
    }

    public void setSmtpAuthenticationAccountUsername(String smtpAuthenticationAccountUsername) {
        this.smtpAuthenticationAccountUsername = smtpAuthenticationAccountUsername;
    }

    public String getSmtpAuthenticationAccountPassword() {
        return this.smtpAuthenticationAccountPassword;
    }

    public void setSmtpAuthenticationAccountPassword(String smtpAuthenticationAccountPassword) {
        this.smtpAuthenticationAccountPassword = smtpAuthenticationAccountPassword;
    }

    public String getSmtpAuthenticationAccountPasswordDecrypted() {
        return this.smtpAuthenticationAccountPasswordDecrypted;
    }

    public void setSmtpAuthenticationAccountPasswordDecrypted(String smtpAuthenticationAccountPasswordDecrypted) {
        this.smtpAuthenticationAccountPasswordDecrypted = smtpAuthenticationAccountPasswordDecrypted;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStorePasswordDecrypted() {
        return this.keyStorePasswordDecrypted;
    }

    public void setKeyStorePasswordDecrypted(String keyStorePasswordDecrypted) {
        this.keyStorePasswordDecrypted = keyStorePasswordDecrypted;
    }

    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public void setKeyStoreAlias(String keyStoreAlias) {
        this.keyStoreAlias = keyStoreAlias;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public void setSigningAlgorithm(String signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
    }
}

