/*
 * Decompiled with CFR 0.152.
 */
package io.jans.util;

import java.util.HashMap;
import java.util.Map;

public final class InterfaceRegistry {
    private static Map<Class, Object> REGISTRY = new HashMap<Class, Object>();
    private static volatile boolean CHECK_INSTANCE_OF = false;

    private InterfaceRegistry() {
    }

    public boolean isCheckWhetherInstanceOf() {
        return CHECK_INSTANCE_OF;
    }

    public static void setCheckWhetherInstanceOf(boolean checkInstanceOf) {
        CHECK_INSTANCE_OF = checkInstanceOf;
    }

    public static synchronized <T> T get(Class classInterface) {
        if (classInterface != null) {
            Object instance = REGISTRY.get(classInterface);
            if (CHECK_INSTANCE_OF) {
                if (classInterface.isInstance(instance)) {
                    return (T)instance;
                }
            } else {
                return (T)instance;
            }
        }
        return null;
    }

    public static synchronized boolean put(Class classInterface, Object classInstance) {
        boolean result = false;
        if (classInterface != null && classInterface.isInterface()) {
            if (classInstance == null) {
                REGISTRY.remove(classInterface);
                result = true;
            } else if (CHECK_INSTANCE_OF) {
                if (classInterface.isInstance(classInstance)) {
                    REGISTRY.put(classInterface, classInstance);
                    result = true;
                }
            } else {
                REGISTRY.put(classInterface, classInstance);
                result = true;
            }
        }
        return result;
    }
}

