/*
 * Decompiled with CFR 0.152.
 */
package io.jans.net;

import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class InetAddressUtility {
    private static final String[] HEADERS_TO_TRY = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR"};
    private static Pattern VALID_IPV4_PATTERN = null;
    private static Pattern VALID_IPV6_PATTERN = null;
    private static final String IPV4_PATTERN = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    private static final String IPV6_PATTERN = "([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}";
    private static String MAC_ADDRESS;
    private static boolean MAC_ADDRESS_SET;

    private InetAddressUtility() {
    }

    public static boolean isIpAddress(String ipAddress) {
        Matcher m1 = VALID_IPV4_PATTERN.matcher(ipAddress);
        if (m1.matches()) {
            return true;
        }
        Matcher m2 = VALID_IPV6_PATTERN.matcher(ipAddress);
        return m2.matches();
    }

    public static String getMACAddressOrNull() {
        if (!MAC_ADDRESS_SET) {
            MAC_ADDRESS = InetAddressUtility.getMACAddressOrNullImpl();
            MAC_ADDRESS_SET = true;
        }
        return MAC_ADDRESS;
    }

    private static synchronized String getMACAddressOrNullImpl() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                return null;
            }
            byte[] mac = network.getHardwareAddress();
            if (mac == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            }
            return sb.toString();
        }
        catch (UnknownHostException e) {
            return null;
        }
        catch (SocketException e) {
            return null;
        }
    }

    public static String getIpAddress(HttpServletRequest httpRequest) {
        for (String header : HEADERS_TO_TRY) {
            String ip = httpRequest.getHeader(header);
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) continue;
            int commaIndex = ip.indexOf(44);
            if (commaIndex > 0) {
                ip = ip.substring(0, commaIndex).trim();
            }
            return ip;
        }
        return httpRequest.getRemoteAddr();
    }

    static {
        VALID_IPV4_PATTERN = Pattern.compile(IPV4_PATTERN, 2);
        VALID_IPV6_PATTERN = Pattern.compile(IPV6_PATTERN, 2);
        MAC_ADDRESS_SET = false;
    }
}

