/*
 * Decompiled with CFR 0.152.
 */
package io.jans.doc.annotation;

import io.jans.doc.annotation.DocFeatureFlag;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"io.jans.doc.annotation.DocFeatureFlag"})
@SupportedOptions(value={"module"})
public class DocFeatureFlagProcessor
extends AbstractProcessor {
    String moduleName;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        this.moduleName = this.processingEnv.getOptions().get("module");
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = env.getElementsAnnotatedWith(typeElement);
            List sortedElements = annotatedElements.stream().sorted((prop1, prop2) -> prop1.getSimpleName().toString().toLowerCase().compareTo(prop2.getSimpleName().toString().toLowerCase())).collect(Collectors.toList());
            StringBuilder docContents = new StringBuilder();
            StringBuilder tableContents = new StringBuilder();
            StringBuilder detailsContent = new StringBuilder();
            this.prepareDocTagsAndTableHeader(docContents, tableContents);
            for (Element element : sortedElements) {
                DocFeatureFlag elementAnnotation = element.getAnnotation(DocFeatureFlag.class);
                DocFeatureFlagProcessor.addToTable(tableContents, element, elementAnnotation);
                DocFeatureFlagProcessor.addToDetails(detailsContent, element, elementAnnotation);
            }
            tableContents.append("\n\n");
            this.createAndWriteDoc(docContents.append((CharSequence)tableContents.append(detailsContent.toString())));
        }
        return false;
    }

    private void prepareDocTagsAndTableHeader(StringBuilder docContents, StringBuilder tableContents) {
        docContents.append("---\n").append("tags:\n").append("- administration\n").append("- reference\n").append("- json\n").append("- feature-flags\n").append("---\n").append("\n").append("# " + this.moduleName + " Feature Flags").append("\n").append("\n");
        tableContents.append("| Feature Flag Name ").append("| Description ").append("|  | ").append("\n").append("|-----|-----|-----|").append("\n");
    }

    private void createAndWriteDoc(StringBuilder docContent) {
        FileObject docFile = null;
        try {
            docFile = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", this.moduleName.toLowerCase().replaceAll("\\s", "") + "-feature-flags.md", new Element[0]);
        }
        catch (IOException ioe) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, this.getClass().getName() + ": Error occurred while creating annotation documentation file");
        }
        if (docFile != null) {
            try (PrintWriter docWriter = new PrintWriter(docFile.openWriter());){
                docWriter.write(docContent.toString());
                docWriter.flush();
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, this.getClass().getName() + ": Error occurred while writing annotation documentation file");
            }
        }
    }

    private static void addToDetails(StringBuilder propDetails, Element jansElement, DocFeatureFlag featureFlagAnnotation) {
        propDetails.append("### " + jansElement.getSimpleName() + "\n\n");
        propDetails.append("- Description: " + featureFlagAnnotation.description() + "\n\n");
        propDetails.append("- Required: " + (featureFlagAnnotation.isRequired() ? "Yes" : "No") + "\n\n");
        propDetails.append("- Default value: " + featureFlagAnnotation.defaultValue() + "\n\n");
        propDetails.append("\n");
    }

    private static void addToTable(StringBuilder propTable, Element jansElement, DocFeatureFlag featureFlagAnnotation) {
        propTable.append("| " + jansElement.getSimpleName() + " ");
        propTable.append("| " + featureFlagAnnotation.description() + " ");
        propTable.append("| [Details](#" + jansElement.getSimpleName().toString().toLowerCase() + ") |");
        propTable.append("\n");
    }
}

