/*
 * Decompiled with CFR 0.152.
 */
package io.jans.fido2.model.conf;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jans.fido2.model.conf.MetadataServer;
import io.jans.fido2.model.conf.RequestedParty;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Fido2Configuration {
    private String authenticatorCertsFolder;
    private String mdsCertsFolder;
    private String mdsTocsFolder;
    private boolean userAutoEnrollment = false;
    private int unfinishedRequestExpiration = 120;
    private int authenticationHistoryExpiration = 1296000;
    private String serverMetadataFolder;
    private List<String> enabledFidoAlgorithms = new ArrayList<String>();
    @JsonProperty(value="rp")
    private List<RequestedParty> requestedParties = new ArrayList<RequestedParty>();
    private List<MetadataServer> metadataServers = new ArrayList<MetadataServer>();
    private boolean disableMetadataService = false;
    private List<String> hints = new ArrayList<String>();
    private boolean enterpriseAttestation = false;
    private String attestationMode = "monitor";

    public String getAuthenticatorCertsFolder() {
        return this.authenticatorCertsFolder;
    }

    public void setAuthenticatorCertsFolder(String authenticatorCertsFolder) {
        this.authenticatorCertsFolder = authenticatorCertsFolder;
    }

    public String getMdsCertsFolder() {
        return this.mdsCertsFolder;
    }

    public void setMdsCertsFolder(String mdsCertsFolder) {
        this.mdsCertsFolder = mdsCertsFolder;
    }

    public String getMdsTocsFolder() {
        return this.mdsTocsFolder;
    }

    public void setMdsTocsFolder(String mdsTocsFolder) {
        this.mdsTocsFolder = mdsTocsFolder;
    }

    public int getUnfinishedRequestExpiration() {
        return this.unfinishedRequestExpiration;
    }

    public void setUnfinishedRequestExpiration(int unfinishedRequestExpiration) {
        this.unfinishedRequestExpiration = unfinishedRequestExpiration;
    }

    public String getServerMetadataFolder() {
        return this.serverMetadataFolder;
    }

    public void setServerMetadataFolder(String serverMetadataFolder) {
        this.serverMetadataFolder = serverMetadataFolder;
    }

    public List<RequestedParty> getRequestedParties() {
        return this.requestedParties;
    }

    public void setRequestedParties(List<RequestedParty> requestedParties) {
        this.requestedParties = requestedParties;
    }

    public List<String> getHints() {
        return this.hints;
    }

    public void setHints(List<String> hints) {
        this.hints = hints;
    }

    public boolean isEnterpriseAttestation() {
        return this.enterpriseAttestation;
    }

    public void setEnterpriseAttestation(boolean enterpriseOnly) {
        this.enterpriseAttestation = enterpriseOnly;
    }

    public int getAuthenticationHistoryExpiration() {
        return this.authenticationHistoryExpiration;
    }

    public void setAuthenticationHistoryExpiration(int authenticationHistoryExpiration) {
        this.authenticationHistoryExpiration = authenticationHistoryExpiration;
    }

    public boolean isUserAutoEnrollment() {
        return this.userAutoEnrollment;
    }

    public void setUserAutoEnrollment(boolean userAutoEnrollment) {
        this.userAutoEnrollment = userAutoEnrollment;
    }

    public List<String> getEnabledFidoAlgorithms() {
        return this.enabledFidoAlgorithms;
    }

    public void setEnabledFidoAlgorithms(List<String> enabledFidoAlgorithms) {
        this.enabledFidoAlgorithms = enabledFidoAlgorithms;
    }

    public boolean isDisableMetadataService() {
        return this.disableMetadataService;
    }

    public void setDisableMetadataService(boolean disableMetadataService) {
        this.disableMetadataService = disableMetadataService;
    }

    public List<MetadataServer> getMetadataServers() {
        return this.metadataServers;
    }

    public void setMetadataServers(List<MetadataServer> metadataServers) {
        this.metadataServers = metadataServers;
    }

    public String getAttestationMode() {
        return this.attestationMode;
    }

    public void setAttestationMode(String attestationMode) {
        this.attestationMode = attestationMode;
    }

    public Fido2Configuration(String authenticatorCertsFolder, String mdsAccessToken, String mdsCertsFolder, String mdsTocsFolder, boolean checkU2fAttestations, boolean debugUserAutoEnrollment, int unfinishedRequestExpiration, int authenticationHistoryExpiration, String serverMetadataFolder, List<String> enabledFidoAlgorithms, List<RequestedParty> requestedParties, List<MetadataServer> metadataServers, boolean disableMetadataService, String attestationMode, List<String> hints, boolean enterpriseAttestation) {
        this.authenticatorCertsFolder = authenticatorCertsFolder;
        this.mdsCertsFolder = mdsCertsFolder;
        this.mdsTocsFolder = mdsTocsFolder;
        this.userAutoEnrollment = debugUserAutoEnrollment;
        this.unfinishedRequestExpiration = unfinishedRequestExpiration;
        this.authenticationHistoryExpiration = authenticationHistoryExpiration;
        this.serverMetadataFolder = serverMetadataFolder;
        this.enabledFidoAlgorithms = enabledFidoAlgorithms;
        this.requestedParties = requestedParties;
        this.metadataServers = metadataServers;
        this.disableMetadataService = disableMetadataService;
        this.attestationMode = attestationMode;
        this.hints = hints;
        this.enterpriseAttestation = enterpriseAttestation;
    }

    public Fido2Configuration() {
    }

    public String toString() {
        return "Fido2Configuration [authenticatorCertsFolder=" + this.authenticatorCertsFolder + ", mdsCertsFolder=" + this.mdsCertsFolder + ", mdsTocsFolder=" + this.mdsTocsFolder + ", userAutoEnrollment=" + this.userAutoEnrollment + ", unfinishedRequestExpiration=" + this.unfinishedRequestExpiration + ", authenticationHistoryExpiration=" + this.authenticationHistoryExpiration + ", serverMetadataFolder=" + this.serverMetadataFolder + ", enabledFidoAlgorithms=" + this.enabledFidoAlgorithms + ", requestedParties=" + this.requestedParties + ", metadataServers=" + this.metadataServers + ", disableMetadataService=" + this.disableMetadataService + ", hints=" + this.hints + ", enterpriseAttestation=" + this.enterpriseAttestation + ", attestationMode=" + this.attestationMode + "]";
    }
}

