/*
 * Decompiled with CFR 0.152.
 */
package io.jans.fido2.model.metric;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.JsonObject;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.model.base.Entry;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@DataEntry
@ObjectClass(value="jansFido2MetricsAggregation")
@JsonIgnoreProperties(ignoreUnknown=true)
public class Fido2MetricsAggregation
extends Entry
implements Serializable {
    private static final long serialVersionUID = 1L;
    @AttributeName(name="jansId")
    private String id;
    @AttributeName(name="jansAggregationType")
    private String aggregationType;
    @AttributeName(name="jansStartTime")
    private LocalDateTime startTime;
    @AttributeName(name="jansEndTime")
    private LocalDateTime endTime;
    @AttributeName(name="jansUniqueUsers")
    private Long uniqueUsers;
    @AttributeName(name="jansLastUpdated")
    private LocalDateTime lastUpdated;
    @AttributeName(name="jansMetricsData")
    @JsonObject
    private transient Map<String, Object> metricsData = new HashMap<String, Object>();

    public Fido2MetricsAggregation() {
    }

    public Fido2MetricsAggregation(String aggregationType, String period, LocalDateTime startTime, LocalDateTime endTime) {
        this();
        this.aggregationType = aggregationType;
        this.id = aggregationType + "_" + period;
        this.startTime = startTime;
        this.endTime = endTime;
        this.lastUpdated = LocalDateTime.now();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAggregationType() {
        return this.aggregationType;
    }

    public void setAggregationType(String aggregationType) {
        this.aggregationType = aggregationType;
    }

    public String getPeriod() {
        if (this.id != null && this.id.contains("_")) {
            return this.id.substring(this.id.indexOf("_") + 1);
        }
        return this.id;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public Long getUniqueUsers() {
        return this.uniqueUsers;
    }

    public void setUniqueUsers(Long uniqueUsers) {
        this.uniqueUsers = uniqueUsers;
    }

    public LocalDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(LocalDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Map<String, Object> getMetricsData() {
        return this.metricsData;
    }

    public void setMetricsData(Map<String, Object> metricsData) {
        this.metricsData = metricsData;
    }

    public Long getRegistrationAttempts() {
        return this.getLongMetric("registrationAttempts");
    }

    public void setRegistrationAttempts(Long value) {
        this.setMetric("registrationAttempts", value);
    }

    public Long getRegistrationSuccesses() {
        return this.getLongMetric("registrationSuccesses");
    }

    public void setRegistrationSuccesses(Long value) {
        this.setMetric("registrationSuccesses", value);
    }

    public Long getRegistrationFailures() {
        return this.getLongMetric("registrationFailures");
    }

    public void setRegistrationFailures(Long value) {
        this.setMetric("registrationFailures", value);
    }

    public Long getAuthenticationAttempts() {
        return this.getLongMetric("authenticationAttempts");
    }

    public void setAuthenticationAttempts(Long value) {
        this.setMetric("authenticationAttempts", value);
    }

    public Long getAuthenticationSuccesses() {
        return this.getLongMetric("authenticationSuccesses");
    }

    public void setAuthenticationSuccesses(Long value) {
        this.setMetric("authenticationSuccesses", value);
    }

    public Long getAuthenticationFailures() {
        return this.getLongMetric("authenticationFailures");
    }

    public void setAuthenticationFailures(Long value) {
        this.setMetric("authenticationFailures", value);
    }

    public Long getFallbackEvents() {
        return this.getLongMetric("fallbackEvents");
    }

    public void setFallbackEvents(Long value) {
        this.setMetric("fallbackEvents", value);
    }

    public Double getRegistrationSuccessRate() {
        return this.getDoubleMetric("registrationSuccessRate");
    }

    public void setRegistrationSuccessRate(Double value) {
        this.setMetric("registrationSuccessRate", value);
    }

    public Double getAuthenticationSuccessRate() {
        return this.getDoubleMetric("authenticationSuccessRate");
    }

    public void setAuthenticationSuccessRate(Double value) {
        this.setMetric("authenticationSuccessRate", value);
    }

    public Double getRegistrationAvgDuration() {
        return this.getDoubleMetric("registrationAvgDuration");
    }

    public void setRegistrationAvgDuration(Double value) {
        this.setMetric("registrationAvgDuration", value);
    }

    public Double getAuthenticationAvgDuration() {
        return this.getDoubleMetric("authenticationAvgDuration");
    }

    public void setAuthenticationAvgDuration(Double value) {
        this.setMetric("authenticationAvgDuration", value);
    }

    public Map<String, Long> getDeviceTypes() {
        return this.getMapMetric("deviceTypes");
    }

    public void setDeviceTypes(Map<String, Long> deviceTypes) {
        this.setMetric("deviceTypes", deviceTypes);
    }

    public Map<String, Long> getErrorCounts() {
        return this.getMapMetric("errorCounts");
    }

    public void setErrorCounts(Map<String, Long> errorCounts) {
        this.setMetric("errorCounts", errorCounts);
    }

    public Long getLongMetric(String key) {
        if (this.metricsData == null) {
            return null;
        }
        Object value = this.metricsData.get(key);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return null;
    }

    public Double getDoubleMetric(String key) {
        if (this.metricsData == null) {
            return null;
        }
        Object value = this.metricsData.get(key);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return null;
    }

    private Map<String, Long> getMapMetric(String key) {
        if (this.metricsData == null) {
            return Collections.emptyMap();
        }
        Object value = this.metricsData.get(key);
        if (value instanceof Map) {
            return (Map)value;
        }
        return Collections.emptyMap();
    }

    private void setMetric(String key, Object value) {
        if (this.metricsData == null) {
            this.metricsData = new HashMap<String, Object>();
        }
        this.metricsData.put(key, value);
    }

    public void incrementMetric(String key, Long increment) {
        Long current = this.getLongMetric(key);
        this.setMetric(key, (current != null ? current : 0L) + (increment != null ? increment : 0L));
    }

    public void setPerformanceMetrics(Map<String, Object> performanceMetrics) {
        this.setMetric("performanceMetrics", performanceMetrics);
    }

    public Map<String, Object> getPerformanceMetrics() {
        if (this.metricsData == null) {
            return Collections.emptyMap();
        }
        Object value = this.metricsData.get("performanceMetrics");
        if (value instanceof Map) {
            return (Map)value;
        }
        return Collections.emptyMap();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Fido2MetricsAggregation that = (Fido2MetricsAggregation)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.aggregationType, that.aggregationType) && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.endTime, that.endTime);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.aggregationType, this.startTime, this.endTime);
    }

    public String toString() {
        return "Fido2MetricsAggregation{id='" + this.id + "', aggregationType='" + this.aggregationType + "', startTime=" + this.startTime + ", endTime=" + this.endTime + ", uniqueUsers=" + this.uniqueUsers + ", lastUpdated=" + this.lastUpdated + ", metricsDataSize=" + (this.metricsData != null ? this.metricsData.size() : 0) + "}";
    }
}

