/*
 * Decompiled with CFR 0.152.
 */
package io.jans.fido2.model.metric;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.JsonObject;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.model.base.Entry;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;

@DataEntry
@ObjectClass(value="jansFido2MetricsEntry")
@JsonIgnoreProperties(ignoreUnknown=true)
public class Fido2MetricsEntry
extends Entry
implements Serializable {
    private static final long serialVersionUID = 1L;
    @AttributeName(name="jansId")
    private String id;
    @AttributeName(name="jansMetricType")
    private String metricType;
    @AttributeName(name="jansTimestamp")
    private LocalDateTime timestamp;
    @AttributeName(name="jansUserId")
    private String userId;
    @AttributeName(name="jansUsername")
    private String username;
    @AttributeName(name="jansOperationType")
    private String operationType;
    @AttributeName(name="jansStatus")
    private String status;
    @AttributeName(name="jansDurationMs")
    private Long durationMs;
    @AttributeName(name="jansAuthenticatorType")
    private String authenticatorType;
    @AttributeName(name="jansDeviceInfo")
    @JsonObject
    private DeviceInfo deviceInfo;
    @AttributeName(name="jansErrorReason")
    private String errorReason;
    @AttributeName(name="jansErrorCategory")
    private String errorCategory;
    @AttributeName(name="jansFallbackMethod")
    private String fallbackMethod;
    @AttributeName(name="jansFallbackReason")
    private String fallbackReason;
    @AttributeName(name="jansUserAgent")
    private String userAgent;
    @AttributeName(name="jansIpAddress")
    private String ipAddress;
    @AttributeName(name="jansSessionId")
    private String sessionId;
    @AttributeName(name="jansAdditionalData")
    @JsonObject
    private transient Map<String, Object> additionalData;
    @AttributeName(name="jansNodeId")
    private String nodeId;
    @AttributeName(name="jansApplicationType")
    private String applicationType;

    public Fido2MetricsEntry() {
    }

    public Fido2MetricsEntry(String metricType, String operationType, String status) {
        this.metricType = metricType;
        this.operationType = operationType;
        this.status = status;
        this.timestamp = LocalDateTime.now();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMetricType() {
        return this.metricType;
    }

    public void setMetricType(String metricType) {
        this.metricType = metricType;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getDurationMs() {
        return this.durationMs;
    }

    public void setDurationMs(Long durationMs) {
        this.durationMs = durationMs;
    }

    public String getAuthenticatorType() {
        return this.authenticatorType;
    }

    public void setAuthenticatorType(String authenticatorType) {
        this.authenticatorType = authenticatorType;
    }

    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    public void setDeviceInfo(DeviceInfo deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public String getErrorReason() {
        return this.errorReason;
    }

    public void setErrorReason(String errorReason) {
        this.errorReason = errorReason;
    }

    public String getErrorCategory() {
        return this.errorCategory;
    }

    public void setErrorCategory(String errorCategory) {
        this.errorCategory = errorCategory;
    }

    public String getFallbackMethod() {
        return this.fallbackMethod;
    }

    public void setFallbackMethod(String fallbackMethod) {
        this.fallbackMethod = fallbackMethod;
    }

    public String getFallbackReason() {
        return this.fallbackReason;
    }

    public void setFallbackReason(String fallbackReason) {
        this.fallbackReason = fallbackReason;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Map<String, Object> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, Object> additionalData) {
        this.additionalData = additionalData;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String toString() {
        return "Fido2MetricsEntry{id='" + this.id + "', metricType='" + this.metricType + "', timestamp=" + this.timestamp + ", userId='" + this.userId + "', username='" + this.username + "', operationType='" + this.operationType + "', status='" + this.status + "', durationMs=" + this.durationMs + ", authenticatorType='" + this.authenticatorType + "', errorReason='" + this.errorReason + "', errorCategory='" + this.errorCategory + "', fallbackMethod='" + this.fallbackMethod + "', fallbackReason='" + this.fallbackReason + "', nodeId='" + this.nodeId + "', applicationType='" + this.applicationType + "'}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Fido2MetricsEntry that = (Fido2MetricsEntry)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.metricType, that.metricType) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.userId, that.userId) && Objects.equals(this.operationType, that.operationType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.metricType, this.timestamp, this.userId, this.operationType);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeviceInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="browser")
        private String browser;
        @JsonProperty(value="browser_version")
        private String browserVersion;
        @JsonProperty(value="os")
        private String os;
        @JsonProperty(value="os_version")
        private String osVersion;
        @JsonProperty(value="device_type")
        private String deviceType;
        @JsonProperty(value="platform")
        private String platform;
        @JsonProperty(value="user_agent")
        private String userAgent;

        public DeviceInfo() {
        }

        public DeviceInfo(String browser, String os, String deviceType) {
            this.browser = browser;
            this.os = os;
            this.deviceType = deviceType;
        }

        public String getBrowser() {
            return this.browser;
        }

        public void setBrowser(String browser) {
            this.browser = browser;
        }

        public String getBrowserVersion() {
            return this.browserVersion;
        }

        public void setBrowserVersion(String browserVersion) {
            this.browserVersion = browserVersion;
        }

        public String getOs() {
            return this.os;
        }

        public void setOs(String os) {
            this.os = os;
        }

        public String getOsVersion() {
            return this.osVersion;
        }

        public void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        public String getDeviceType() {
            return this.deviceType;
        }

        public void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        public String getPlatform() {
            return this.platform;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        public String toString() {
            return "DeviceInfo{browser='" + this.browser + "', browserVersion='" + this.browserVersion + "', os='" + this.os + "', osVersion='" + this.osVersion + "', deviceType='" + this.deviceType + "', platform='" + this.platform + "'}";
        }
    }
}

