/*
 * Decompiled with CFR 0.152.
 */
package io.jans.keycloak.link.service;

import io.jans.keycloak.link.model.JansInumMap;
import io.jans.link.model.GluuCustomPerson;
import io.jans.link.model.GluuSimplePerson;
import io.jans.link.service.InumService;
import io.jans.model.JansCustomAttribute;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.ldap.impl.LdapFilterConverter;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.util.ArrayHelper;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;

@ApplicationScoped
public class LinkInterceptionService {
    @Inject
    private Logger log;
    @Inject
    private LdapFilterConverter ldapFilterConverter;
    @Inject
    private InumService inumService;

    public Filter createFilter(String customLdapFilter) throws SearchException {
        if (StringHelper.isEmpty((String)customLdapFilter)) {
            return null;
        }
        return this.ldapFilterConverter.convertRawLdapFilterToFilter(customLdapFilter);
    }

    public Filter createFilter(String[] keyAttributes, String[] keyObjectClasses, String keyAttributeStart, Filter customFilter) throws SearchException {
        if (keyAttributes == null || keyObjectClasses == null) {
            return null;
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (int i = 0; i < keyAttributes.length; ++i) {
            String filterString = keyAttributes[i];
            if (filterString.contains("=")) {
                filters.add(this.ldapFilterConverter.convertRawLdapFilterToFilter(filterString));
            }
            if (i != 0 || keyAttributeStart == null) continue;
            int index = filterString.indexOf(61);
            if (index != -1) {
                filterString = filterString.substring(0, index);
            }
            filterString = String.format("%s=%s*", filterString, keyAttributeStart);
            filters.add(this.ldapFilterConverter.convertRawLdapFilterToFilter(filterString));
        }
        for (String keyObjectClass : keyObjectClasses) {
            filters.add(Filter.createEqualityFilter((String)"objectClass", (Object)keyObjectClass));
        }
        if (customFilter != null) {
            filters.add(customFilter);
        }
        return Filter.createANDFilter(filters);
    }

    public Filter createObjectClassPresenceFilter() {
        return Filter.createPresenceFilter((String)"objectClass");
    }

    public void addInumMap(PersistenceEntryManager ldapEntryManager, JansInumMap inumMap) {
        ldapEntryManager.persist((Object)inumMap);
    }

    public boolean containsInumMap(PersistenceEntryManager ldapEntryManager, String dn) {
        return ldapEntryManager.contains(dn, JansInumMap.class);
    }

    public String generateInumForNewInumMap(String inumbBaseDn, PersistenceEntryManager ldapEntryManager) {
        String newInum;
        String newDn;
        while (this.containsInumMap(ldapEntryManager, newDn = this.getDnForInum(inumbBaseDn, newInum = this.generateInumForNewInumMapImpl()))) {
        }
        return newInum;
    }

    public String getDnForInum(String baseDn, String inum) {
        return String.format("inum=%s,%s", inum, baseDn);
    }

    private String generateInumForNewInumMapImpl() {
        String inum = this.inumService.generateInums("people");
        return inum;
    }

    public void setTargetEntryAttributes(GluuSimplePerson sourcePerson, Map<String, String> targetServerAttributesMapping, GluuCustomPerson targetPerson) {
        HashMap<String, JansCustomAttribute> customAttributesMap = new HashMap<String, JansCustomAttribute>();
        for (JansCustomAttribute sourceCustomAttribute : sourcePerson.getCustomAttributes()) {
            customAttributesMap.put(StringHelper.toLowerCase((String)sourceCustomAttribute.getName()), sourceCustomAttribute);
        }
        ArrayList<JansCustomAttribute> resultAttributes = new ArrayList<JansCustomAttribute>();
        HashSet<String> processedAttributeNames = new HashSet<String>();
        for (Map.Entry<String, String> entry : targetServerAttributesMapping.entrySet()) {
            String sourceKeyAttributeName = StringHelper.toLowerCase((String)entry.getValue());
            String targetKeyAttributeName = entry.getKey();
            processedAttributeNames.add(sourceKeyAttributeName);
            JansCustomAttribute gluuCustomAttribute = (JansCustomAttribute)customAttributesMap.get(sourceKeyAttributeName);
            if (gluuCustomAttribute == null) continue;
            Object[] values = gluuCustomAttribute.getStringValues();
            Object[] clonedValue = (String[])ArrayHelper.arrayClone((Object[])values);
            JansCustomAttribute gluuCustomAttributeCopy = new JansCustomAttribute(targetKeyAttributeName, clonedValue);
            gluuCustomAttributeCopy.setName(targetKeyAttributeName);
            resultAttributes.add(gluuCustomAttributeCopy);
        }
        for (Map.Entry<String, String> entry : customAttributesMap.entrySet()) {
            if (processedAttributeNames.contains(entry.getKey())) continue;
            targetPerson.setAttribute((JansCustomAttribute)entry.getValue());
        }
        for (JansCustomAttribute jansCustomAttribute : resultAttributes) {
            targetPerson.setAttribute(jansCustomAttribute);
        }
    }
}

