/*
 * Decompiled with CFR 0.152.
 */
package io.jans.keycloak.link.service;

import io.jans.keycloak.link.service.IPersonService;
import io.jans.link.model.GluuCustomPerson;
import io.jans.link.service.OrganizationService;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.search.filter.Filter;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;

@ApplicationScoped
public class PersonService
implements Serializable,
IPersonService {
    private static final long serialVersionUID = 6685720517520443399L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private OrganizationService organizationService;

    public void addPersonWithoutCheck(GluuCustomPerson person) {
        person.setCreationDate(new Date());
        this.persistenceEntryManager.persist((Object)person);
    }

    public void updatePersonWithoutCheck(GluuCustomPerson person) {
        Date updateDate = new Date();
        person.setUpdatedAt(updateDate);
        if (person.getAttribute("oxTrustMetaLastModified") != null) {
            person.setAttribute("oxTrustMetaLastModified", Instant.ofEpochMilli(updateDate.getTime()).toString());
        }
        this.persistenceEntryManager.merge((Object)person);
    }

    @Override
    public GluuCustomPerson findPersonByDn(String dn, String ... returnAttributes) {
        return (GluuCustomPerson)this.persistenceEntryManager.find((Object)dn, GluuCustomPerson.class, returnAttributes);
    }

    @Override
    public boolean contains(String dn) {
        return this.persistenceEntryManager.contains(dn, GluuCustomPerson.class);
    }

    @Override
    public String getDnForPerson(String inum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=person,%s", orgDn);
        }
        return String.format("inum=%s,ou=people,%s", inum, orgDn);
    }

    public String generateInumForNewPersonImpl() {
        String id = null;
        return id == null ? UUID.randomUUID().toString() : id;
    }

    public List<GluuCustomPerson> getPersonsByUid(String uid, String ... returnAttributes) {
        this.log.debug("Getting user information from DB: userId = {}", (Object)uid);
        if (StringHelper.isEmpty((String)uid)) {
            return null;
        }
        String personDn = this.getDnForPerson(null);
        Filter userUidFilter = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (Object)StringHelper.toLowerCase((String)uid));
        List entries = this.persistenceEntryManager.findEntries(personDn, GluuCustomPerson.class, userUidFilter, returnAttributes);
        this.log.debug("Found {} entries for userId = {}", (Object)entries.size(), (Object)uid);
        return entries;
    }
}

