/*
 * Decompiled with CFR 0.152.
 */
package io.jans.link.service;

import io.jans.link.service.OrganizationService;
import io.jans.model.GluuAttributeUsageType;
import io.jans.model.GluuUserRole;
import io.jans.model.JansAttribute;
import io.jans.model.JansCustomAttribute;
import io.jans.model.attribute.AttributeDataType;
import io.jans.model.user.UserRole;
import io.jans.orm.search.filter.Filter;
import io.jans.service.BaseCacheService;
import io.jans.util.StringHelper;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class AttributeService
extends io.jans.service.AttributeService {
    private GluuUserRole[] attributeEditTypes = new GluuUserRole[]{GluuUserRole.ADMIN, GluuUserRole.USER};
    private static final long serialVersionUID = 8223624816948822765L;
    @Inject
    private OrganizationService organizationService;
    public static final String CUSTOM_ATTRIBUTE_OBJECTCLASS_PREFIX = "ox-";

    public List<JansAttribute> getAllPersonAttributes(GluuUserRole gluuUserRole) {
        String key = "personAttributeList_" + gluuUserRole.getValue();
        List<JansAttribute> attributeList = (List<JansAttribute>)this.cacheService.get(key);
        if (attributeList == null) {
            attributeList = this.getAllPersonAtributesImpl(gluuUserRole, this.getAllAttributes());
            this.cacheService.put(key, attributeList);
        }
        return attributeList;
    }

    private List<JansAttribute> getAllPersonAtributesImpl(GluuUserRole gluuUserRole, Collection<JansAttribute> attributes) {
        ArrayList<JansAttribute> attributeList = new ArrayList<JansAttribute>();
        Object[] objectClassTypes = this.getPersonObjectClassTypes();
        this.log.debug("objectClassTypes={}", (Object)Arrays.toString(objectClassTypes));
        block0: for (JansAttribute attribute : attributes) {
            if (StringHelper.equalsIgnoreCase((String)attribute.getOrigin(), (String)this.getPersonCustomObjectClass()) && GluuUserRole.ADMIN == gluuUserRole) {
                attribute.setCustom(true);
                attributeList.add(attribute);
                continue;
            }
            for (Object objectClassType : objectClassTypes) {
                if (!attribute.getOrigin().equals(objectClassType) || !attribute.allowViewBy(gluuUserRole) && !attribute.allowEditBy(gluuUserRole)) continue;
                attributeList.add(attribute);
                continue block0;
            }
        }
        return attributeList;
    }

    public List<JansAttribute> getAllActiveAttributes(GluuUserRole gluuUserRole) {
        String key = "personAttributeList_" + gluuUserRole.getValue();
        List<JansAttribute> attributeList = (List<JansAttribute>)this.cacheService.get(key);
        if (attributeList == null) {
            attributeList = this.getAllPersonAtributes(gluuUserRole, this.getAllAttributes());
            this.cacheService.put(key, attributeList);
        }
        return attributeList;
    }

    public boolean attributeWithSameNameDontExist(String name) {
        Filter nameFilter = Filter.createEqualityFilter((String)"name", (Object)name);
        List result = this.persistenceEntryManager.findEntries(this.getDnForAttribute(null), JansAttribute.class, nameFilter, null);
        return result == null || result.isEmpty();
    }

    private List<JansAttribute> getAllPersonAtributes(GluuUserRole gluuUserRole, Collection<JansAttribute> attributes) {
        ArrayList<JansAttribute> attributeList = new ArrayList<JansAttribute>();
        Object[] objectClassTypes = this.getPersonObjectClassTypes();
        this.log.debug("objectClassTypes={}", (Object)Arrays.toString(objectClassTypes));
        block0: for (JansAttribute attribute : attributes) {
            if (StringHelper.equalsIgnoreCase((String)attribute.getOrigin(), (String)this.getPersonCustomObjectClass()) && GluuUserRole.ADMIN == gluuUserRole) {
                attribute.setCustom(true);
                attributeList.add(attribute);
                continue;
            }
            for (Object objectClassType : objectClassTypes) {
                if (!attribute.getOrigin().equals(objectClassType)) continue;
                attributeList.add(attribute);
                continue block0;
            }
        }
        return attributeList;
    }

    public List<JansAttribute> getAllContactAttributes(GluuUserRole gluuUserRole) {
        String key = "contactAttributeList_" + gluuUserRole.getValue();
        List<JansAttribute> attributeList = (List<JansAttribute>)this.cacheService.get(key);
        if (attributeList == null) {
            attributeList = this.getAllContactAtributesImpl(gluuUserRole, this.getAllAttributes());
            this.cacheService.put(key, attributeList);
        }
        return attributeList;
    }

    private List<JansAttribute> getAllContactAtributesImpl(GluuUserRole gluuUserRole, Collection<JansAttribute> attributes) {
        ArrayList<JansAttribute> returnAttributeList = new ArrayList<JansAttribute>();
        String[] objectClassTypes = this.getPersonObjectClassTypes();
        block0: for (JansAttribute attribute : attributes) {
            if (StringHelper.equalsIgnoreCase((String)attribute.getOrigin(), (String)this.getPersonCustomObjectClass()) && GluuUserRole.ADMIN == gluuUserRole) {
                attribute.setCustom(true);
                returnAttributeList.add(attribute);
                continue;
            }
            for (String objectClassType : objectClassTypes) {
                if (!attribute.getOrigin().equals(objectClassType) || !attribute.allowViewBy(gluuUserRole) && !attribute.allowEditBy(gluuUserRole)) continue;
                returnAttributeList.add(attribute);
                continue block0;
            }
        }
        return returnAttributeList;
    }

    public List<String> getAllAttributeOrigins() {
        List<String> attributeOriginList = (List<String>)this.cacheService.get("attributeOriginList");
        if (attributeOriginList == null) {
            attributeOriginList = this.getAllAttributeOrigins(this.getAllAttributes());
            this.cacheService.put("attributeOriginList", attributeOriginList);
        }
        return attributeOriginList;
    }

    public List<String> getAllAttributeOrigins(Collection<JansAttribute> attributes) {
        ArrayList<String> attributeOriginList = new ArrayList<String>();
        for (JansAttribute attribute : attributes) {
            String origin = attribute.getOrigin();
            if (attributeOriginList.contains(origin)) continue;
            attributeOriginList.add(attribute.getOrigin());
        }
        String customOrigin = this.getCustomOrigin();
        if (!attributeOriginList.contains(customOrigin)) {
            attributeOriginList.add(customOrigin);
        }
        return attributeOriginList;
    }

    public Map<String, String> getAllAttributeOriginDisplayNames(List<String> attributeOriginList, String[] objectClassTypes, String[] objectClassDisplayNames) {
        HashMap<String, String> attributeOriginDisplayNameMap = new HashMap<String, String>();
        for (String origin : attributeOriginList) {
            attributeOriginDisplayNameMap.put(origin, origin);
        }
        if (objectClassTypes.length == objectClassDisplayNames.length) {
            for (int i = 0; i < objectClassTypes.length; ++i) {
                String objectClass = objectClassTypes[i];
                if (!attributeOriginDisplayNameMap.containsKey(objectClass)) continue;
                attributeOriginDisplayNameMap.put(objectClass, objectClassDisplayNames[i]);
            }
        }
        return attributeOriginDisplayNameMap;
    }

    public List<JansAttribute> getCustomAttributes() {
        ArrayList<JansAttribute> attributeList = (ArrayList<JansAttribute>)this.cacheService.get("customAttributeList");
        if (attributeList == null) {
            attributeList = new ArrayList<JansAttribute>();
            for (JansAttribute attribute : this.getAllAttributes()) {
                if (!attribute.isCustom()) continue;
                attributeList.add(attribute);
            }
            this.cacheService.put("customAttributeList", attributeList);
        }
        return attributeList;
    }

    public JansAttribute getAttributeByInum(String inum) {
        return this.getAttributeByInum(inum, this.getAllAtributesImpl(this.getDnForAttribute(null)));
    }

    public JansAttribute getAttributeByInum(String inum, List<JansAttribute> attributes) {
        for (JansAttribute attribute : attributes) {
            if (!attribute.getInum().equals(inum)) continue;
            return attribute;
        }
        return null;
    }

    public AttributeDataType[] getDataTypes() {
        return AttributeDataType.values();
    }

    public UserRole[] getAttributeUserRoles() {
        return new UserRole[]{UserRole.ADMIN, UserRole.USER};
    }

    public UserRole[] getViewTypes() {
        return new UserRole[]{UserRole.ADMIN, UserRole.USER};
    }

    public GluuAttributeUsageType[] getAttributeUsageTypes() {
        return new GluuAttributeUsageType[]{GluuAttributeUsageType.OPENID};
    }

    public boolean containsAttribute(JansAttribute attribute) {
        return this.persistenceEntryManager.contains((Object)attribute);
    }

    public boolean containsAttribute(String dn) {
        return this.persistenceEntryManager.contains(dn, JansAttribute.class);
    }

    public String generateInumForNewAttribute() {
        String newInum = null;
        String newDn = null;
        while (this.containsAttribute(newDn = this.getDnForAttribute(newInum = this.generateInumForNewAttributeImpl()))) {
        }
        return newInum;
    }

    public String toInumWithoutDelimiters(String inum) {
        return inum.replace(".", "").replace("!", "").replace("@", "");
    }

    public String generateRandomOid() {
        return Long.toString(System.currentTimeMillis());
    }

    private String generateInumForNewAttributeImpl() {
        return UUID.randomUUID().toString();
    }

    public String getDnForAttribute(String inum) {
        String organizationDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=attributes,%s", organizationDn);
        }
        return String.format("inum=%s,ou=attributes,%s", inum, organizationDn);
    }

    public String getCustomOrigin() {
        return this.getPersonCustomObjectClass();
    }

    public abstract String getPersonCustomObjectClass();

    public abstract String[] getPersonObjectClassTypes();

    protected List<JansAttribute> getAllAtributesImpl(String baseDn) {
        List attributeList = this.persistenceEntryManager.findEntries(baseDn, JansAttribute.class, null);
        String customOrigin = this.getCustomOrigin();
        for (JansAttribute attribute : attributeList) {
            attribute.setCustom(customOrigin.equals(attribute.getOrigin()));
        }
        return attributeList;
    }

    public void setAttributeMetadata(List<JansCustomAttribute> customAttributes, List<JansAttribute> attributes) {
        if (customAttributes == null || attributes == null) {
            return;
        }
        for (JansCustomAttribute personAttribute : customAttributes) {
            JansAttribute tmpAttribute = this.getAttributeByName(personAttribute.getName(), attributes);
            if (tmpAttribute == null) {
                this.log.warn("Failed to find attribute '{}' metadata", (Object)personAttribute.getName());
            }
            personAttribute.setMetadata(tmpAttribute);
        }
    }

    public List<JansCustomAttribute> getCustomAttributesByAttributeDNs(List<String> attributeDNs, HashMap<String, JansAttribute> attributesByDNs) {
        ArrayList<JansCustomAttribute> customAttributes = new ArrayList<JansCustomAttribute>();
        if (attributeDNs == null) {
            return customAttributes;
        }
        for (String releasedAttributeDn : attributeDNs) {
            JansAttribute attribute = attributesByDNs.get(releasedAttributeDn);
            if (attribute == null) continue;
            JansCustomAttribute customAttribute = new JansCustomAttribute(attribute.getName(), (Object)releasedAttributeDn);
            customAttribute.setMetadata(attribute);
            customAttributes.add(customAttribute);
        }
        return customAttributes;
    }

    public HashMap<String, JansAttribute> getAttributeMapByDNs(List<JansAttribute> attributes) {
        HashMap<String, JansAttribute> attributeDns = new HashMap<String, JansAttribute>();
        for (JansAttribute attribute : attributes) {
            attributeDns.put(attribute.getDn(), attribute);
        }
        return attributeDns;
    }

    public void sortCustomAttributes(List<JansCustomAttribute> customAttributes, String sortByProperties) {
        this.persistenceEntryManager.sortListByProperties(JansCustomAttribute.class, customAttributes, false, new String[]{sortByProperties});
    }

    public String getDnForGroup(String inum) throws Exception {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=groups,%s", orgDn);
        }
        return String.format("inum=%s,ou=groups,%s", inum, orgDn);
    }

    public List<JansAttribute> getAllActivePersonAttributes(GluuUserRole admin) {
        List<JansAttribute> activeAttributeList = (List<JansAttribute>)this.cacheService.get("ActiveAttributeCache", "activeAttributeList");
        if (activeAttributeList == null) {
            activeAttributeList = this.getAllActiveAtributesImpl(admin);
            this.cacheService.put("attributeList", activeAttributeList);
        }
        return activeAttributeList;
    }

    private List<JansAttribute> getAllActiveAtributesImpl(GluuUserRole gluuUserRole) {
        Filter filter = Filter.createEqualityFilter((String)"gluuStatus", (Object)"active");
        List attributeList = this.persistenceEntryManager.findEntries(this.getDnForAttribute(null), JansAttribute.class, filter);
        String customOrigin = this.getCustomOrigin();
        Object[] objectClassTypes = this.getPersonObjectClassTypes();
        this.log.debug("objectClassTypes={}", (Object)Arrays.toString(objectClassTypes));
        ArrayList<JansAttribute> returnAttributeList = new ArrayList<JansAttribute>();
        block0: for (JansAttribute attribute : attributeList) {
            if (StringHelper.equalsIgnoreCase((String)attribute.getOrigin(), (String)this.getPersonCustomObjectClass()) && GluuUserRole.ADMIN == gluuUserRole) {
                attribute.setCustom(true);
                returnAttributeList.add(attribute);
                continue;
            }
            for (Object objectClassType : objectClassTypes) {
                if (!attribute.getOrigin().equals(objectClassType)) continue;
                attribute.setCustom(customOrigin.equals(attribute.getOrigin()));
                returnAttributeList.add(attribute);
                continue block0;
            }
        }
        return returnAttributeList;
    }

    public List<JansAttribute> searchAttributes(String pattern, int sizeLimit) throws Exception {
        String[] targetArray = new String[]{pattern};
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        Filter nameFilter = Filter.createSubstringFilter((String)"jansAttrName", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, nameFilter});
        List result = this.persistenceEntryManager.findEntries(this.getDnForAttribute(null), JansAttribute.class, searchFilter, sizeLimit);
        String customOrigin = this.getCustomOrigin();
        for (JansAttribute attribute : result) {
            attribute.setCustom(customOrigin.equals(attribute.getOrigin()));
        }
        return result;
    }

    public List<JansAttribute> searchPersonAttributes(String pattern, int sizeLimit) throws Exception {
        String[] objectClassTypes = this.getPersonObjectClassTypes();
        String[] targetArray = new String[]{pattern};
        ArrayList<Filter> originFilters = new ArrayList<Filter>();
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        for (String objectClassType : objectClassTypes) {
            Filter originFilter = Filter.createEqualityFilter((String)"jansAttrOrigin", (Object)objectClassType);
            originFilters.add(originFilter);
        }
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter});
        Filter originFilter = Filter.createORFilter((Filter[])originFilters.toArray(new Filter[0]));
        Filter filter = Filter.createANDFilter((Filter[])new Filter[]{searchFilter, originFilter});
        return this.persistenceEntryManager.findEntries(this.getDnForAttribute(null), JansAttribute.class, filter, sizeLimit);
    }

    public JansAttribute getAttributeByDn(String Dn) throws Exception {
        return (JansAttribute)this.persistenceEntryManager.find(JansAttribute.class, (Object)Dn);
    }

    public GluuUserRole[] getAttributeEditTypes() {
        return this.attributeEditTypes;
    }

    public void setAttributeEditTypes(GluuUserRole[] attributeEditTypes) {
        this.attributeEditTypes = attributeEditTypes;
    }

    protected BaseCacheService getCacheService() {
        return this.cacheService;
    }

    public String getPersistenceType() {
        return this.persistenceEntryManager.getPersistenceType();
    }
}

