/*
 * Decompiled with CFR 0.152.
 */
package io.jans.link.service;

import io.jans.link.external.ExternalLinkService;
import io.jans.link.model.GluuCustomPerson;
import io.jans.link.model.GluuSimplePerson;
import io.jans.link.model.JansInumMap;
import io.jans.link.model.config.shared.LinkAttributeMapping;
import io.jans.link.model.config.shared.LinkConfiguration;
import io.jans.link.service.Fido2DeviceService;
import io.jans.link.service.FidoDeviceService;
import io.jans.link.service.InumService;
import io.jans.link.service.LinkService;
import io.jans.link.service.LinkSnapshotFileService;
import io.jans.link.service.LinkUpdateMethod;
import io.jans.link.service.PairwiseIdService;
import io.jans.link.service.PersonService;
import io.jans.link.util.PropertyUtil;
import io.jans.model.GluuStatus;
import io.jans.model.JansCustomAttribute;
import io.jans.model.SchemaEntry;
import io.jans.model.ldap.GluuLdapConfiguration;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.PersistenceEntryManagerFactory;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.exception.BasePersistenceException;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.ldap.operation.LdapOperationService;
import io.jans.orm.model.SearchScope;
import io.jans.orm.model.base.DummyEntry;
import io.jans.orm.operation.PersistenceOperationService;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.util.ArrayHelper;
import io.jans.orm.util.StringHelper;
import io.jans.service.EncryptionService;
import io.jans.service.ObjectSerializationService;
import io.jans.service.SchemaService;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;

public abstract class BaseJansLinkTimer {
    private static final String LETTERS_FOR_SEARCH = "abcdefghijklmnopqrstuvwxyz1234567890.";
    private static final String[] TARGET_PERSON_RETURN_ATTRIBUTES = new String[]{"inum"};
    @Inject
    private Logger log;
    @Inject
    private LinkService linkService;
    @Inject
    private PersonService personService;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private LinkSnapshotFileService linkSnapshotFileService;
    @Inject
    private ExternalLinkService externalLinkService;
    @Inject
    private SchemaService schemaService;
    @Inject
    private InumService inumService;
    @Inject
    private EncryptionService encryptionService;
    @Inject
    private PairwiseIdService pairwiseIdService;
    @Inject
    private FidoDeviceService fidoDeviceService;
    @Inject
    private Fido2DeviceService fido2DeviceService;
    @Inject
    private ObjectSerializationService objectSerializationService;
    private AtomicBoolean isActive;
    private long lastFinishedTime;

    public Set<String> getChangedInums(HashMap<String, Integer> currInumWithEntryHashCodeMap, Map<String, Integer> prevInumWithEntryHashCodeMap, boolean includeDeleted) {
        HashSet<String> changedInums = null;
        if (prevInumWithEntryHashCodeMap == null) {
            changedInums = new HashSet<String>(currInumWithEntryHashCodeMap.keySet());
        } else {
            changedInums = new HashSet();
            if (includeDeleted) {
                for (String string : prevInumWithEntryHashCodeMap.keySet()) {
                    if (currInumWithEntryHashCodeMap.containsKey(string)) continue;
                    changedInums.add(string);
                }
            }
            for (Map.Entry entry : currInumWithEntryHashCodeMap.entrySet()) {
                String currInumKey = (String)entry.getKey();
                Integer prevHashCode = prevInumWithEntryHashCodeMap.get(currInumKey);
                if (prevHashCode != null && (prevHashCode == null || prevHashCode.equals(entry.getValue()))) continue;
                changedInums.add(currInumKey);
            }
        }
        return changedInums;
    }

    public List<GluuSimplePerson> getRemovedPersons(HashMap<String, Integer> currInumWithEntryHashCodeMap, Map<String, Integer> prevInumWithEntryHashCodeMap) {
        if (prevInumWithEntryHashCodeMap == null) {
            return new ArrayList<GluuSimplePerson>(0);
        }
        HashSet<String> deletedInums = new HashSet<String>();
        for (String prevInumKey : prevInumWithEntryHashCodeMap.keySet()) {
            if (currInumWithEntryHashCodeMap.containsKey(prevInumKey)) continue;
            deletedInums.add(prevInumKey);
        }
        ArrayList<GluuSimplePerson> deletedPersons = new ArrayList<GluuSimplePerson>(deletedInums.size());
        for (String deletedInum : deletedInums) {
            GluuSimplePerson person = new GluuSimplePerson();
            String personDn = this.personService.getDnForPerson(deletedInum);
            person.setDn(personDn);
            ArrayList<JansCustomAttribute> customAttributes = new ArrayList<JansCustomAttribute>();
            customAttributes.add(new JansCustomAttribute("inum", (Object)deletedInum));
            person.setCustomAttributes(customAttributes);
            deletedPersons.add(person);
        }
        return deletedPersons;
    }

    public List<String> updateTargetEntriesViaVDS(LinkConfiguration linkConfiguration, LdapServerConnection targetServerConnection, Set<String> changedInums) {
        ArrayList<String> result = new ArrayList<String>();
        PersistenceEntryManager targetPersistenceEntryManager = targetServerConnection.getPersistenceEntryManager();
        Filter filter = this.linkService.createObjectClassPresenceFilter();
        for (String changedInum : changedInums) {
            String baseDn = "action=synchronizecache," + this.personService.getDnForPerson(changedInum);
            try {
                targetPersistenceEntryManager.findEntries(baseDn, DummyEntry.class, filter, SearchScope.SUB, null, null, 0, 0, linkConfiguration.getLdapSearchSizeLimit());
                result.add(changedInum);
                this.log.info("Updated entry with inum {}" + changedInum);
            }
            catch (BasePersistenceException ex) {
                this.log.error("Failed to update entry with inum '{}' using baseDN {}" + changedInum, (Object)baseDn, (Object)ex);
            }
        }
        return result;
    }

    public boolean validateTargetServerSchema(LinkConfiguration linkConfiguration, Map<String, String> targetServerAttributesMapping, String[] customObjectClasses) {
        String[] keyAttributesWithoutValues = this.getCompoundKeyAttributesWithoutValues(linkConfiguration);
        String[] sourceAttributes = this.getSourceAttributes(linkConfiguration);
        String[] returnAttributes = (String[])ArrayHelper.arrayMerge((Object[][])new String[][]{keyAttributesWithoutValues, sourceAttributes});
        GluuSimplePerson sourcePerson = new GluuSimplePerson();
        for (String returnAttribute : returnAttributes) {
            sourcePerson.setAttribute(returnAttribute, "Test");
        }
        String targetInum = this.inumService.generateInums("people", false);
        String targetPersonDn = this.personService.getDnForPerson(targetInum);
        GluuCustomPerson targetPerson = new GluuCustomPerson();
        targetPerson.setDn(targetPersonDn);
        targetPerson.setInum(targetInum);
        targetPerson.setStatus(GluuStatus.ACTIVE.getValue());
        targetPerson.setCustomObjectClasses(customObjectClasses);
        this.linkService.setTargetEntryAttributes(sourcePerson, targetServerAttributesMapping, targetPerson);
        this.externalLinkService.executeExternalUpdateUserMethods(targetPerson);
        boolean executionResult = this.externalLinkService.executeExternalUpdateUserMethods(targetPerson);
        if (!executionResult) {
            this.log.error("Failed to execute Link Interception scripts for person '{}'" + targetInum);
            return false;
        }
        List customAttributes = targetPerson.getCustomAttributes();
        ArrayList<String> targetAttributes = new ArrayList<String>(customAttributes.size());
        for (JansCustomAttribute customAttribute : customAttributes) {
            targetAttributes.add(customAttribute.getName());
        }
        List<String> targetObjectClasses = Arrays.asList(this.getLdapEntryManager().getObjectClasses((Object)targetPerson, GluuCustomPerson.class));
        return this.validateTargetServerSchema(targetObjectClasses, targetAttributes);
    }

    private boolean validateTargetServerSchema(List<String> targetObjectClasses, List<String> targetAttributes) {
        SchemaEntry schemaEntry = this.schemaService.getSchema();
        if (schemaEntry == null) {
            return true;
        }
        Set objectClassesAttributesSet = this.schemaService.getObjectClassesAttributes(schemaEntry, targetObjectClasses.toArray(new String[0]));
        LinkedHashSet<String> targetAttributesSet = new LinkedHashSet<String>();
        for (String attrbute : targetAttributes) {
            targetAttributesSet.add(StringHelper.toLowerCase((String)attrbute));
        }
        targetAttributesSet.removeAll(objectClassesAttributesSet);
        if (targetAttributesSet.size() == 0) {
            return true;
        }
        this.log.error("Skipping target entries update. Destination server schema doesn't has next attributes: '{}', target OC: '{}', target OC attributes: '{}'" + targetAttributesSet, (Object)targetObjectClasses.toArray(new String[0]), (Object)objectClassesAttributesSet);
        return false;
    }

    public boolean updateTargetEntryViaCopy(GluuSimplePerson sourcePerson, String targetInum, String[] targetCustomObjectClasses, Map<String, String> targetServerAttributesMapping) {
        boolean updatePerson;
        String targetPersonDn = this.personService.getDnForPerson(targetInum);
        GluuCustomPerson targetPerson = null;
        if (this.personService.contains(targetPersonDn)) {
            try {
                targetPerson = this.personService.findPersonByDn(targetPersonDn, new String[0]);
                this.log.info("Found person by inum '{}'" + targetInum);
            }
            catch (EntryPersistenceException ex) {
                this.log.error("Failed to find person '{}'" + targetInum, (Throwable)ex);
                return false;
            }
            updatePerson = true;
        } else {
            targetPerson = new GluuCustomPerson();
            targetPerson.setDn(targetPersonDn);
            targetPerson.setInum(targetInum);
            targetPerson.setStatus(GluuStatus.ACTIVE.getValue());
            updatePerson = false;
        }
        if (PersistenceEntryManager.PERSITENCE_TYPES.ldap.name().equals(this.getLdapEntryManager().getPersistenceType())) {
            targetPerson.setCustomObjectClasses(targetCustomObjectClasses);
        }
        targetPerson.setSourceServerName(sourcePerson.getSourceServerName());
        targetPerson.setSourceServerUserDn(sourcePerson.getDn());
        this.linkService.setTargetEntryAttributes(sourcePerson, targetServerAttributesMapping, targetPerson);
        boolean executionResult = this.externalLinkService.executeExternalUpdateUserMethods(targetPerson);
        if (!executionResult) {
            this.log.error("Failed to execute Link Interception scripts for person '{}'" + targetInum);
            return false;
        }
        try {
            if (updatePerson) {
                this.personService.updatePersonWithoutCheck(targetPerson);
                this.log.info("Updated person '{}'" + targetInum);
            } else {
                this.personService.addPersonWithoutCheck(targetPerson);
                this.log.info("Added new person '{}'" + targetInum);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String test = updatePerson ? "update" : "add";
            this.log.error("Failed to '{}' person '{}'" + test + targetInum + ex);
            return false;
        }
        return true;
    }

    public List<GluuSimplePerson> loadSourceServerEntriesWithoutLimits(LinkConfiguration LinkConfiguration2, LdapServerConnection[] sourceServerConnections) throws SearchException {
        Filter customFilter = this.linkService.createFilter(LinkConfiguration2.getCustomLdapFilter());
        String[] keyAttributes = this.getCompoundKeyAttributes(LinkConfiguration2);
        String[] keyAttributesWithoutValues = this.getCompoundKeyAttributesWithoutValues(LinkConfiguration2);
        String[] keyObjectClasses = this.getCompoundKeyObjectClasses(LinkConfiguration2);
        String[] sourceAttributes = this.getSourceAttributes(LinkConfiguration2);
        String[] returnAttributes = (String[])ArrayHelper.arrayMerge((Object[][])new String[][]{keyAttributesWithoutValues, sourceAttributes});
        HashSet<String> addedDns = new HashSet<String>();
        ArrayList<GluuSimplePerson> sourcePersons = new ArrayList<GluuSimplePerson>();
        for (LdapServerConnection sourceServerConnection : sourceServerConnections) {
            String sourceServerName = sourceServerConnection.getSourceServerName();
            PersistenceEntryManager sourcePersistenceEntryManager = sourceServerConnection.getPersistenceEntryManager();
            String[] baseDns = sourceServerConnection.getBaseDns();
            Filter filter = this.linkService.createFilter(keyAttributes, keyObjectClasses, "", customFilter);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Using next filter to load entris from source server: {}" + filter);
            }
            for (String baseDn : baseDns) {
                List currentSourcePersons = sourcePersistenceEntryManager.findEntries(baseDn, GluuSimplePerson.class, filter, SearchScope.SUB, returnAttributes, null, 0, 0, LinkConfiguration2.getLdapSearchSizeLimit());
                for (GluuSimplePerson currentSourcePerson : currentSourcePersons) {
                    currentSourcePerson.setSourceServerName(sourceServerName);
                    String currentSourcePersonDn = currentSourcePerson.getDn().toLowerCase();
                    if (addedDns.contains(currentSourcePersonDn)) continue;
                    sourcePersons.add(currentSourcePerson);
                    addedDns.add(currentSourcePersonDn);
                }
            }
        }
        return sourcePersons;
    }

    public List<GluuSimplePerson> loadSourceServerEntries(LinkConfiguration LinkConfiguration2, LdapServerConnection[] sourceServerConnections) throws SearchException {
        Filter customFilter = this.linkService.createFilter(LinkConfiguration2.getCustomLdapFilter());
        String[] keyAttributes = this.getCompoundKeyAttributes(LinkConfiguration2);
        String[] keyAttributesWithoutValues = this.getCompoundKeyAttributesWithoutValues(LinkConfiguration2);
        String[] keyObjectClasses = this.getCompoundKeyObjectClasses(LinkConfiguration2);
        String[] sourceAttributes = this.getSourceAttributes(LinkConfiguration2);
        String[] twoLettersArray = this.createTwoLettersArray();
        String[] returnAttributes = (String[])ArrayHelper.arrayMerge((Object[][])new String[][]{keyAttributesWithoutValues, sourceAttributes});
        HashSet<String> addedDns = new HashSet<String>();
        ArrayList<GluuSimplePerson> sourcePersons = new ArrayList<GluuSimplePerson>();
        for (LdapServerConnection sourceServerConnection : sourceServerConnections) {
            String sourceServerName = sourceServerConnection.getSourceServerName();
            PersistenceEntryManager sourcePersistenceEntryManager = sourceServerConnection.getPersistenceEntryManager();
            String[] baseDns = sourceServerConnection.getBaseDns();
            for (String keyAttributeStart : twoLettersArray) {
                Filter filter = this.linkService.createFilter(keyAttributes, keyObjectClasses, keyAttributeStart, customFilter);
                if (this.log.isDebugEnabled()) {
                    this.log.trace("Using next filter to load entris from source server: {}" + filter);
                }
                for (String baseDn : baseDns) {
                    List currentSourcePersons = sourcePersistenceEntryManager.findEntries(baseDn, GluuSimplePerson.class, filter, SearchScope.SUB, returnAttributes, null, 0, 0, LinkConfiguration2.getLdapSearchSizeLimit());
                    for (GluuSimplePerson currentSourcePerson : currentSourcePersons) {
                        currentSourcePerson.setSourceServerName(sourceServerName);
                        String currentSourcePersonDn = currentSourcePerson.getDn().toLowerCase();
                        if (addedDns.contains(currentSourcePersonDn)) continue;
                        sourcePersons.add(currentSourcePerson);
                        addedDns.add(currentSourcePersonDn);
                    }
                }
            }
        }
        return sourcePersons;
    }

    public List<TypedGluuSimplePerson> loadTargetServerEntries(LinkConfiguration LinkConfiguration2, PersistenceEntryManager targetPersistenceEntryManager) {
        Filter filter = Filter.createEqualityFilter((String)"objectClass", (Object)"jansPerson");
        return targetPersistenceEntryManager.findEntries(this.personService.getDnForPerson(null), TypedGluuSimplePerson.class, filter, SearchScope.SUB, TARGET_PERSON_RETURN_ATTRIBUTES, null, 0, 0, LinkConfiguration2.getLdapSearchSizeLimit());
    }

    public JansInumMap addGluuInumMap(String inumbBaseDn, PersistenceEntryManager inumDbPersistenceEntryManager, String[] primaryKeyAttrName, String[][] primaryKeyValues) {
        String inum = this.linkService.generateInumForNewInumMap(inumbBaseDn, inumDbPersistenceEntryManager);
        String inumDn = this.linkService.getDnForInum(inumbBaseDn, inum);
        JansInumMap inumMap = new JansInumMap();
        inumMap.setDn(inumDn);
        inumMap.setInum(inum);
        inumMap.setPrimaryKeyAttrName(primaryKeyAttrName[0]);
        inumMap.setPrimaryKeyValues(primaryKeyValues[0]);
        if (primaryKeyAttrName.length > 1) {
            inumMap.setSecondaryKeyAttrName(primaryKeyAttrName[1]);
            inumMap.setSecondaryKeyValues(primaryKeyValues[1]);
        }
        if (primaryKeyAttrName.length > 2) {
            inumMap.setTertiaryKeyAttrName(primaryKeyAttrName[2]);
            inumMap.setTertiaryKeyValues(primaryKeyValues[2]);
        }
        inumMap.setStatus(GluuStatus.ACTIVE);
        this.linkService.addInumMap(inumDbPersistenceEntryManager, inumMap);
        return inumMap;
    }

    public List<GluuSimplePerson> processTargetPersons(List<TypedGluuSimplePerson> targetPersons, HashMap<String, Integer> currInumWithEntryHashCodeMap) {
        ArrayList<GluuSimplePerson> result = new ArrayList<GluuSimplePerson>();
        for (GluuSimplePerson gluuSimplePerson : targetPersons) {
            String personInum = gluuSimplePerson.getStringAttribute("inum");
            if (currInumWithEntryHashCodeMap.containsKey(personInum)) continue;
            this.log.info("Person with such DN: '{}' isn't present on source server" + gluuSimplePerson.getDn());
            result.add(gluuSimplePerson);
        }
        return result;
    }

    public void closeLdapServerConnection(LdapServerConnection ... ldapServerConnections) {
        for (LdapServerConnection ldapServerConnection : ldapServerConnections) {
            if (ldapServerConnection == null || ldapServerConnection.getPersistenceEntryManager() == null) continue;
            ldapServerConnection.getPersistenceEntryManager().destroy();
        }
    }

    private String[] createTwoLettersArray() {
        char[] characters = LETTERS_FOR_SEARCH.toCharArray();
        int lettersCount = characters.length;
        String[] result = new String[lettersCount * lettersCount];
        for (int i = 0; i < lettersCount; ++i) {
            for (int j = 0; j < lettersCount; ++j) {
                result[i * lettersCount + j] = "" + characters[i] + characters[j];
            }
        }
        return result;
    }

    public String getInumCachePath(LinkConfiguration LinkConfiguration2) {
        return FilenameUtils.concat((String)LinkConfiguration2.getSnapshotFolder(), (String)"inum_cache.dat");
    }

    public PersistenceEntryManager getLdapEntryManager() {
        return this.ldapEntryManager;
    }

    public void setLdapEntryManager(PersistenceEntryManager ldapEntryManager) {
        this.ldapEntryManager = ldapEntryManager;
    }

    public LinkUpdateMethod getUpdateMethod(LinkConfiguration LinkConfiguration2) {
        String updateMethod = LinkConfiguration2.getUpdateMethod();
        if (StringHelper.isEmpty((String)updateMethod)) {
            return LinkUpdateMethod.COPY;
        }
        return LinkUpdateMethod.getByValue(LinkConfiguration2.getUpdateMethod());
    }

    public String[] getSourceAttributes(LinkConfiguration LinkConfiguration2) {
        return LinkConfiguration2.getSourceAttributes().toArray(new String[0]);
    }

    public String[] getCompoundKeyObjectClasses(LinkConfiguration LinkConfiguration2) {
        return LinkConfiguration2.getKeyObjectClasses().toArray(new String[0]);
    }

    public String[] getCompoundKeyAttributes(LinkConfiguration LinkConfiguration2) {
        return LinkConfiguration2.getKeyAttributes().toArray(new String[0]);
    }

    public String[] getCompoundKeyAttributesWithoutValues(LinkConfiguration LinkConfiguration2) {
        String[] result = LinkConfiguration2.getKeyAttributes().toArray(new String[0]);
        for (int i = 0; i < result.length; ++i) {
            int index = result[i].indexOf(61);
            if (index == -1) continue;
            result[i] = result[i].substring(0, index);
        }
        return result;
    }

    public Map<String, String> getTargetServerAttributesMapping(LinkConfiguration LinkConfiguration2) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (LinkAttributeMapping attributeMapping : LinkConfiguration2.getAttributeMapping()) {
            result.put(attributeMapping.getDestination(), attributeMapping.getSource());
        }
        return result;
    }

    public Properties toLdapProperties(PersistenceEntryManagerFactory ldapEntryManagerFactory, GluuLdapConfiguration ldapConfiguration) {
        String persistenceType = ldapEntryManagerFactory.getPersistenceType();
        Properties ldapProperties = new Properties();
        ldapProperties.put(persistenceType + "#servers", PropertyUtil.simplePropertiesToCommaSeparatedList(ldapConfiguration.getServers()));
        ldapProperties.put(persistenceType + "#maxconnections", Integer.toString(ldapConfiguration.getMaxConnections()));
        ldapProperties.put(persistenceType + "#useSSL", Boolean.toString(ldapConfiguration.isUseSSL()));
        ldapProperties.put(persistenceType + "#bindDN", ldapConfiguration.getBindDN());
        ldapProperties.put(persistenceType + "#bindPassword", ldapConfiguration.getBindPassword());
        PersistenceOperationService persistenceOperationService = this.getLdapEntryManager().getOperationService();
        if (persistenceOperationService instanceof LdapOperationService) {
            ldapProperties.put(persistenceType + "#binaryAttributes", PropertyUtil.stringsToCommaSeparatedList(((LdapOperationService)persistenceOperationService).getConnectionProvider().getBinaryAttributes()));
        }
        return ldapProperties;
    }

    public String[] getBaseDNs(GluuLdapConfiguration ldapConfiguration) {
        return ldapConfiguration.getBaseDNsStringsList().toArray(new String[0]);
    }

    public AtomicBoolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(AtomicBoolean isActive) {
        this.isActive = isActive;
    }

    @ObjectClass(value="gluuPerson")
    public class TypedGluuSimplePerson
    extends GluuSimplePerson {
    }

    public class LdapServerConnection {
        private String sourceServerName;
        private PersistenceEntryManager ldapEntryManager;
        private String[] baseDns;

        public LdapServerConnection(String sourceServerName, PersistenceEntryManager ldapEntryManager, String[] baseDns) {
            this.sourceServerName = sourceServerName;
            this.ldapEntryManager = ldapEntryManager;
            this.baseDns = baseDns;
        }

        public final String getSourceServerName() {
            return this.sourceServerName;
        }

        public final PersistenceEntryManager getPersistenceEntryManager() {
            return this.ldapEntryManager;
        }

        public final String[] getBaseDns() {
            return this.baseDns;
        }
    }
}

