/*
 * Decompiled with CFR 0.152.
 */
package io.jans.link.external;

import io.jans.link.external.ExternalScriptService;
import io.jans.link.model.GluuCustomPerson;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.model.bind.BindCredentials;
import io.jans.model.custom.script.type.user.LinkInterceptionType;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import java.util.Map;

@ApplicationScoped
@Named(value="externalLinkService")
public class ExternalLinkService
extends ExternalScriptService {
    private static final long serialVersionUID = 1707751544454591273L;

    public ExternalLinkService() {
        super(CustomScriptType.LINK_INTERCEPTION);
    }

    public boolean executeExternalUpdateUserMethod(CustomScriptConfiguration customScriptConfiguration, GluuCustomPerson user) {
        try {
            this.log.debug("Executing python 'updateUser' method");
            LinkInterceptionType externalType = (LinkInterceptionType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalType.updateUser((Object)user, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public BindCredentials executeExternalGetBindCredentialsMethod(CustomScriptConfiguration customScriptConfiguration, String configId) {
        try {
            this.log.debug("Executing python 'getBindCredentialsMethod' method");
            LinkInterceptionType externalType = (LinkInterceptionType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            if (externalType.getApiVersion() > 1) {
                return externalType.getBindCredentials(configId, configurationAttributes);
            }
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
        }
        return null;
    }

    public boolean executeExternalIsStartProcessMethod(CustomScriptConfiguration customScriptConfiguration) {
        try {
            this.log.debug("Executing python 'executeExternalIsStartProcessMethod' method");
            LinkInterceptionType externalType = (LinkInterceptionType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            if (externalType.getApiVersion() > 2) {
                return externalType.isStartProcess(configurationAttributes);
            }
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
        }
        return false;
    }

    public boolean executeExternalUpdateUserMethods(GluuCustomPerson user) {
        boolean result = true;
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurations) {
            if (result &= this.executeExternalUpdateUserMethod(customScriptConfiguration, user)) continue;
            return result;
        }
        return result;
    }

    public BindCredentials executeExternalGetBindCredentialsMethods(String configId) {
        BindCredentials result = null;
        if (this.customScriptConfigurations == null) {
            this.reload(CustomScriptType.LINK_INTERCEPTION.toString());
        }
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurations) {
            result = this.executeExternalGetBindCredentialsMethod(customScriptConfiguration, configId);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public boolean executeExternalIsStartProcessMethods() {
        if (this.customScriptConfigurations == null) {
            this.reload(CustomScriptType.LINK_INTERCEPTION.toString());
        }
        boolean result = this.customScriptConfigurations.size() > 0;
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurations) {
            if (result &= this.executeExternalIsStartProcessMethod(customScriptConfiguration)) continue;
            return result;
        }
        return result;
    }
}

