/*
 * Decompiled with CFR 0.152.
 */
package io.jans.link.service;

import io.jans.link.model.config.shared.LinkConfiguration;
import io.jans.util.ArrayHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="linkSnapshotFileService")
public class LinkSnapshotFileService {
    @Inject
    private Logger log;
    private static final String SNAPSHOT_FILE_NAME_PATTERN = "inum-snapshot-%s.txt";
    private static final String PROBLEM_LIST_FILE_NAME = "problem-inum-list.txt";
    private static final String SNAPSHOT_FILE_NAME_DATE_PATTERN = "yyyy-MM-dd-HH-mm";

    public boolean prepareSnapshotsFolder(LinkConfiguration linkConfiguration) {
        String snapshotFolder = linkConfiguration.getSnapshotFolder();
        try {
            File dir = new File(snapshotFolder);
            if (!dir.exists()) {
                FileUtils.forceMkdir((File)dir);
            }
        }
        catch (IOException ex) {
            this.log.error("Failed to create snapshot folder '{}'", (Object)snapshotFolder, (Object)ex);
            return false;
        }
        return true;
    }

    public boolean createSnapshot(LinkConfiguration linkConfiguration, Map<String, Integer> inumWithEntryHashCodeMap) {
        if (!this.prepareSnapshotsFolder(linkConfiguration)) {
            return false;
        }
        SimpleDateFormat fileNameDateFormat = new SimpleDateFormat(SNAPSHOT_FILE_NAME_DATE_PATTERN);
        String snapshotFileName = String.format(SNAPSHOT_FILE_NAME_PATTERN, fileNameDateFormat.format(new Date()));
        File file = new File(linkConfiguration.getSnapshotFolder() + File.separator + snapshotFileName);
        try (BufferedWriter bos = new BufferedWriter(new FileWriter(file));){
            for (Map.Entry<String, Integer> entry : inumWithEntryHashCodeMap.entrySet()) {
                bos.write(String.format("%s:%d\n", entry.getKey(), entry.getValue()));
            }
            bos.flush();
        }
        catch (IOException ex) {
            this.log.error("Failed to create snapshot file '{}'", (Object)file.getAbsolutePath(), (Object)ex);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<String, Integer> readSnapshot(LinkConfiguration linkConfiguration, String snapshotFileName) {
        if (!this.prepareSnapshotsFolder(linkConfiguration)) {
            return null;
        }
        File file = new File(linkConfiguration.getSnapshotFolder() + File.separator + snapshotFileName);
        if (!file.exists()) {
            return null;
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try (BufferedReader bis = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = bis.readLine()) != null) {
                String[] lineValues = line.split(":");
                if (lineValues.length != 2) {
                    this.log.error("Failed to parse line: {}", (Object)line);
                    Map<String, Integer> map = null;
                    return map;
                }
                try {
                    result.put(lineValues[0], Integer.valueOf(lineValues[1]));
                }
                catch (RuntimeException ex) {
                    this.log.error("Failed to parse '{}' to integer", (Object)lineValues[1], (Object)ex);
                    Map<String, Integer> map = null;
                    bis.close();
                    return map;
                }
            }
        }
        catch (IOException ex) {
            this.log.error("Failed to load snapshot file '{}'", (Object)file.getAbsolutePath(), (Object)ex);
            return null;
        }
        return result;
    }

    public Map<String, Integer> readLastSnapshot(LinkConfiguration linkConfiguration) {
        if (!this.prepareSnapshotsFolder(linkConfiguration)) {
            return null;
        }
        Object[] snapshots = this.getSnapshotsList(linkConfiguration);
        if (ArrayHelper.isEmpty((Object[])snapshots)) {
            return null;
        }
        return this.readSnapshot(linkConfiguration, (String)snapshots[snapshots.length - 1]);
    }

    private String[] getSnapshotsList(LinkConfiguration linkConfiguration) {
        File file = new File(linkConfiguration.getSnapshotFolder());
        Object[] files = file.list((FilenameFilter)new WildcardFileFilter(String.format(SNAPSHOT_FILE_NAME_PATTERN, "*")));
        Arrays.sort(files);
        return files;
    }

    public boolean retainSnapshots(LinkConfiguration linkConfiguration, int count) {
        if (!this.prepareSnapshotsFolder(linkConfiguration)) {
            return false;
        }
        Object[] snapshots = this.getSnapshotsList(linkConfiguration);
        if (ArrayHelper.isEmpty((Object[])snapshots)) {
            return true;
        }
        for (int i = 0; i < snapshots.length - count; ++i) {
            File file = new File(linkConfiguration.getSnapshotFolder() + File.separator + (String)snapshots[i]);
            if (file.delete()) continue;
            this.log.error("Failed to remove snaphost file '{}'", (Object)file.getAbsolutePath());
        }
        return true;
    }

    public List<String> readProblemList(LinkConfiguration linkConfiguration) {
        if (!this.prepareSnapshotsFolder(linkConfiguration)) {
            return null;
        }
        File file = new File(linkConfiguration.getSnapshotFolder() + File.separator + PROBLEM_LIST_FILE_NAME);
        if (!file.exists()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader bis = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = bis.readLine()) != null) {
                result.add(line);
            }
        }
        catch (IOException ex) {
            this.log.error("Failed to load problem list from file '{}'", (Object)file.getAbsolutePath(), (Object)ex);
            return null;
        }
        return result;
    }

    public boolean writeProblemList(LinkConfiguration linkConfiguration, Set<String> changedInums) {
        if (!this.prepareSnapshotsFolder(linkConfiguration)) {
            return false;
        }
        File file = new File(linkConfiguration.getSnapshotFolder() + File.separator + PROBLEM_LIST_FILE_NAME);
        try (BufferedWriter bos = new BufferedWriter(new FileWriter(file));){
            for (String changedInum : changedInums) {
                bos.write(String.format("%s\n", changedInum));
            }
            bos.flush();
        }
        catch (IOException ex) {
            this.log.error("Failed to write problem list to file '{}'", (Object)file.getAbsolutePath(), (Object)ex);
            return false;
        }
        return true;
    }
}

