/*
 * Decompiled with CFR 0.152.
 */
package io.jans.link.util;

import io.jans.model.SimpleProperty;
import io.jans.service.EncryptionService;
import io.jans.util.StringHelper;
import io.jans.util.security.StringEncrypter;
import jakarta.inject.Inject;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;

public class PropertyUtil {
    private static final Logger log = Logger.getLogger(PropertyUtil.class);
    @Inject
    private EncryptionService encryptionService;

    public String encryptString(String value) {
        try {
            return this.encryptionService.encrypt(value);
        }
        catch (StringEncrypter.EncryptionException ex) {
            log.error((Object)("Failed to encrypt string: " + value), (Throwable)ex);
            return null;
        }
    }

    public static String stringsToCommaSeparatedList(List<String> values) {
        StringBuilder sb = new StringBuilder();
        int count = values.size();
        for (int i = 0; i < count; ++i) {
            sb.append(PropertyUtil.escapeString(values.get(i)));
            if (i >= count - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String simplePropertiesToCommaSeparatedList(List<SimpleProperty> values) {
        StringBuilder sb = new StringBuilder();
        int count = values.size();
        for (int i = 0; i < count; ++i) {
            sb.append(PropertyUtil.escapeString(values.get(i).getValue()));
            if (i >= count - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String escapeString(String value) {
        if (StringHelper.isEmpty((String)value)) {
            return "";
        }
        return PropertyUtil.escapeComma(StringEscapeUtils.escapeJava((String)value));
    }

    private static String escapeComma(String s) {
        StringBuffer buf = new StringBuffer(s);
        for (int i = 0; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            if (c != ',') continue;
            buf.insert(i, '\\');
            ++i;
        }
        return buf.toString();
    }

    public static boolean isEmptyString(String string) {
        return StringHelper.isEmpty((String)string);
    }
}

