/*
 * Decompiled with CFR 0.152.
 */
package io.jans.link.service;

import io.jans.link.model.GluuCustomPerson;
import io.jans.model.JansAttribute;
import io.jans.orm.PersistenceEntryManager;
import io.jans.util.INumGenerator;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class InumService
implements Serializable {
    private static final long serialVersionUID = 6685720517520443399L;
    private static final String PEOPLE = "0000";
    private static final String GROUP = "0003";
    private static final String ATTRIBUTE = "0005";
    private static final String TRUST_RELATIONSHIP = "0006";
    private static final String SEPARATOR = "!";
    private static final int MAX = 10;
    @Inject
    private Logger log;
    @Inject
    PersistenceEntryManager ldapEntryManager;

    public boolean contains(String inum, String type) {
        boolean contains = false;
        if ("attribute".equals(type)) {
            contains = this.containsAttribute(inum);
        } else if ("people".equals(type)) {
            contains = this.containsPerson(inum);
        }
        return contains;
    }

    public boolean containsAttribute(String inum) {
        String dn = "inum=" + inum + ",ou=attributes,o=jans";
        return this.ldapEntryManager.contains(dn, JansAttribute.class);
    }

    public boolean containsPerson(String inum) {
        boolean contains = true;
        String dn = String.format("inum=%s,ou=people,o=jans", inum);
        contains = this.ldapEntryManager.contains(dn, GluuCustomPerson.class);
        if (contains) {
            return true;
        }
        contains = this.ldapEntryManager.contains(dn, GluuCustomPerson.class);
        return contains;
    }

    public String generateInums(String type) {
        return this.generateInums(type, true);
    }

    public String generateInums(String type, boolean checkInDb) {
        String inum = "";
        int counter = 0;
        try {
            while ((inum = this.getInum(type)) != null && !inum.trim().equals("") && checkInDb && this.contains(inum, type)) {
                if (counter > 10) {
                    inum = "";
                    this.log.error("Infinite loop problem while generating new inum");
                    break;
                }
                ++counter;
            }
        }
        catch (Exception ex) {
            this.log.error("Failed to generate inum", (Throwable)ex);
        }
        return inum;
    }

    private String getInum(String type) {
        Object inum = "";
        if ("people".equals(type)) {
            inum = "0000!" + this.generateInum(2);
        } else if ("group".equals(type)) {
            inum = "0003!" + this.generateInum(2);
        } else if ("attribute".equals(type)) {
            inum = "0005!" + this.generateInum(2);
        } else if ("trelationship".equals(type)) {
            inum = "0006!" + this.generateInum(2);
        }
        return inum;
    }

    private String generateInum(int size) {
        String inum = "";
        while (true) {
            inum = INumGenerator.generate((int)size);
            try {
                long value = Long.parseLong(inum.replace(".", ""), 16);
                if (value >= 7L) break;
            }
            catch (Exception ex) {
                this.log.error("Error generating inum: " + ex.getMessage());
                break;
            }
        }
        return inum;
    }
}

