/*
 * Decompiled with CFR 0.152.
 */
package io.jans.link.service;

import io.jans.link.model.GluuCustomPerson;
import io.jans.link.model.GluuUserPairwiseIdentifier;
import io.jans.link.service.IPairwiseIdService;
import io.jans.link.service.OrganizationService;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

@ApplicationScoped
public class PairwiseIdService
implements IPairwiseIdService,
Serializable {
    private static final long serialVersionUID = -758342433526960035L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private OrganizationService organizationService;

    @Override
    public boolean removePairWiseIdentifier(GluuCustomPerson person, GluuUserPairwiseIdentifier pairwiseIdentifier) {
        try {
            String finalDn = String.format("oxId=%s,ou=pairwiseIdentifiers,", pairwiseIdentifier.getOxId());
            finalDn = finalDn.concat(person.getDn());
            this.ldapEntryManager.removeRecursively(finalDn, GluuCustomPerson.class);
            return true;
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            return false;
        }
    }

    @Override
    public String getDnForPairWiseIdentifier(String oxid, String personInum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (!StringHelper.isEmpty((String)personInum) && StringHelper.isEmpty((String)oxid)) {
            return String.format("ou=pairwiseIdentifiers,inum=%s,ou=people,%s", personInum, orgDn);
        }
        if (!StringHelper.isEmpty((String)oxid) && !StringHelper.isEmpty((String)personInum)) {
            return String.format("oxId=%s,ou=pairwiseIdentifiers,inum=%s,ou=people,%s", oxid, personInum, orgDn);
        }
        return "";
    }

    @Override
    public List<GluuUserPairwiseIdentifier> findAllUserPairwiseIdentifiers(GluuCustomPerson person) {
        try {
            List results = this.ldapEntryManager.findEntries(this.getDnForPairWiseIdentifier(null, person.getInum()), GluuUserPairwiseIdentifier.class, null);
            if (results == null) {
                return new ArrayList<GluuUserPairwiseIdentifier>();
            }
            return results;
        }
        catch (Exception e) {
            this.log.warn("Current user don't pairwise identifiers");
            return new ArrayList<GluuUserPairwiseIdentifier>();
        }
    }
}

