/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.cedarling.service.filter;

import io.jans.lock.cedarling.service.filter.CedarlingProtection;
import io.jans.lock.cedarling.service.security.api.ProtectedCedarlingApi;
import io.jans.lock.model.config.AppConfiguration;
import io.jans.lock.model.config.LockProtectionMode;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.slf4j.Logger;

@ProtectedCedarlingApi
@Priority(value=1001)
@Dependent
public class CedarlingAuthorizationProcessingFilter
implements ContainerRequestFilter {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private CedarlingProtection protectionService;
    @Context
    private HttpHeaders httpHeaders;
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String path = requestContext.getUriInfo().getPath();
        this.log.debug("REST call to '{}' intercepted", (Object)path);
        if (LockProtectionMode.CEDARLING.equals((Object)this.appConfiguration.getProtectionMode())) {
            Response authorizationResponse = this.protectionService.processAuthorization(requestContext, this.httpHeaders, this.resourceInfo);
            if (authorizationResponse == null) {
                this.log.debug("Authorization passed");
            } else {
                requestContext.abortWith(authorizationResponse);
            }
        }
    }

    private Response unprotectedApiResponse(String name) {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)(name + " API not protected")).build();
    }

    private Response disabledApiResponse(String name) {
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)(name + " API is disabled")).build();
    }
}

