/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.cedarling.service;

import io.jans.cedarling.binding.wrapper.CedarlingAdapter;
import io.jans.lock.cedarling.config.BootstrapConfig;
import io.jans.lock.model.config.AppConfiguration;
import io.jans.lock.model.config.cedarling.CedarlingConfiguration;
import io.jans.lock.model.config.cedarling.CedarlingPolicyConfiguration;
import io.jans.service.cdi.event.ApplicationInitialized;
import io.jans.service.cdi.event.ApplicationInitializedEvent;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.json.JSONObject;
import org.slf4j.Logger;
import uniffi.cedarling_uniffi.AuthorizeResult;
import uniffi.cedarling_uniffi.CedarlingException;

@ApplicationScoped
public class CedarlingAuthorizationService {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private CedarlingPolicyConfiguration policyConfiguration;
    private CedarlingAdapter cedarlingAdapter;
    private boolean initialized = false;

    @PostConstruct
    public void init() {
        this.log.info("Initialising Cedarling service");
        CedarlingConfiguration cedarConf = this.appConfiguration.getCedarlingConfiguration();
        if (cedarConf.isEnabled()) {
            this.cedarlingAdapter = this.initAdapter(cedarConf);
            this.initialized = true;
        } else {
            this.log.info("Cedarling is disabled");
        }
    }

    @PreDestroy
    public void destroy() {
        this.log.info("Destroying Cedarling service");
        if (this.initialized) {
            this.cedarlingAdapter.close();
        }
        this.log.info("Cedarling is destroyed");
    }

    public void initEvent(@Observes @ApplicationInitialized(value=ApplicationScoped.class) ApplicationInitializedEvent event) {
    }

    private CedarlingAdapter initAdapter(CedarlingConfiguration cedarConf) {
        BootstrapConfig config = BootstrapConfig.builder().applicationName("Lock Server").policyStoreLocal(this.policyConfiguration.getPolicy()).userAuthz(false).workloadAuthz(true).logType(cedarConf.getLogType()).logLevel(cedarConf.getLogLevel()).build();
        try {
            CedarlingAdapter cedarlingAdapter = new CedarlingAdapter();
            String jsonConfig = config.toJsonConfig();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Cedarling JSON configuration: {}", (Object)jsonConfig);
            }
            cedarlingAdapter.loadFromJson(jsonConfig);
            this.log.info("Cedarling initialized successfully");
            return cedarlingAdapter;
        }
        catch (CedarlingException ex) {
            this.log.error("Failed to initialize Cedarling!", (Throwable)ex);
            this.log.trace("Configuration: {}", (Object)config.toJsonConfig());
            return null;
        }
    }

    public boolean authorize(Map<String, String> tokens, String action, Map<String, Object> resource, Map<String, Object> context) {
        JSONObject resourceObject = new JSONObject(Optional.ofNullable(resource).map(Map.class::cast).orElse(Collections.emptyMap()));
        JSONObject contextObject = new JSONObject(Optional.ofNullable(context).map(Map.class::cast).orElse(Collections.emptyMap()));
        return this.authorize(tokens, action, resourceObject, contextObject);
    }

    public boolean authorize(Map<String, String> tokens, String action, JSONObject resource, JSONObject context) {
        try {
            AuthorizeResult res;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Before executing authorization request. tokens: {}, action: {}, resource: {}, context: {}", new Object[]{tokens, action, resource, context});
            }
            if ((res = this.cedarlingAdapter.authorize(tokens, action, resource, context)) == null) {
                this.log.error("Authorization response is empty for request with tokens: {}, action: {}, resource: {}, context: {}", new Object[]{tokens, action, resource, context});
                return false;
            }
            String requestId = res.getRequestId();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Authorization workload decision {} for requestId {}, tokens: {}, action: {}, resource: {}, context: {}", new Object[]{res.getDecision(), requestId, tokens, action, resource, context});
            }
            return res.getDecision();
        }
        catch (Exception ex) {
            this.log.error("Failed to execute Cedarling authorize: tokens: {}, action: {}, resource: {}, context: {}", new Object[]{tokens, action, resource, context, ex});
            return false;
        }
    }
}

